{------------------------------------------------------------------------------}
{ SibVRV
{ svWinGL Unit
{ Created 11.04.2001 by Vereshagin Roman Vladimirovich.
{ History:
(  VR - Unit Created
{------------------------------------------------------------------------------}
unit svOpenGL1x;

interface
Uses
  {$ifdef MSWINDOWS} Windows           {$endif}
  {$ifdef LINUX}     LibC, XLib, Types {$endif}
  ,
  svVectorTypes,
  svStrings
  ;
Const
    opengl32 = 'opengl32.dll';
    glu32    = 'glu32.dll';

{$I 'svOpenGL1x/svGLTypes.inc'}

{$I 'svOpenGL1x/svGL_bVarARB.inc'}

var
   GL_VERSION_1_0  : Boolean;
   GL_VERSION_1_1  : Boolean;
   GL_VERSION_1_2  : Boolean;
   GL_VERSION_1_3  : Boolean;
   GL_VERSION_1_4  : Boolean;
   GL_VERSION_1_5  : Boolean;

   GL_3DFX_multisample,
   GL_3DFX_tbuffer,
   GL_3DFX_texture_compression_FXT1,

   GL_EXT_abgr,
   GL_EXT_bgra,
   GL_EXT_blend_color,
   GL_EXT_blend_func_separate,
   GL_EXT_blend_logic_op,
   GL_EXT_blend_minmax,
   GL_EXT_blend_subtract,
   GL_EXT_clip_volume_hint,
   GL_EXT_cmyka,
   GL_EXT_compiled_vertex_array,
   GL_EXT_copy_texture,
   GL_EXT_draw_range_elements,
   GL_EXT_fog_coord,
   GL_EXT_light_max_exponent,
   GL_EXT_misc_attribute,
   GL_EXT_multi_draw_arrays,
   GL_EXT_multisample,
   GL_EXT_packed_pixels,
   GL_EXT_paletted_texture,
   GL_EXT_polygon_offset,
   GL_EXT_rescale_normal,
   GL_EXT_scene_marker,
   GL_EXT_secondary_color,
   GL_EXT_separate_specular_color,
   GL_EXT_shared_texture_palette,
   GL_EXT_stencil_wrap,
   GL_EXT_stencil_two_side,
   GL_EXT_subtexture,
   GL_EXT_texture_color_table,
   GL_EXT_texture_compression_s3tc,
   GL_EXT_texture_cube_map,
   GL_EXT_texture_edge_clamp,
   GL_EXT_texture_env_add,
   GL_EXT_texture_env_combine,
   GL_EXT_texture_filter_anisotropic,
   GL_EXT_texture_lod_bias,
   GL_EXT_texture_object,
   GL_EXT_texture_perturb_normal,
   GL_EXT_texture3D,
   GL_EXT_vertex_array,
   GL_EXT_vertex_weighting,

   GL_HP_occlusion_test,

   GL_IBM_rasterpos_clip,

   GL_KTX_buffer_region,

   GL_MESA_resize_buffers,

   GL_NV_blend_square,
   GL_NV_fog_distance,
   GL_NV_light_max_exponent,
   GL_NV_register_combiners,
   GL_NV_texgen_emboss,
   GL_NV_texgen_reflection,
   GL_NV_texture_env_combine4,
   GL_NV_vertex_array_range,
   GL_NV_vertex_program,
   GL_NV_multisample_filter_hint,
   GL_NV_fence,
   GL_NV_occlusion_query,
   GL_NV_texture_rectangle,

   GL_SGI_color_matrix,

   GL_SGIS_generate_mipmap,
   GL_SGIS_multisample,
   GL_SGIS_multitexture,
   GL_SGIS_texture_border_clamp,
   GL_SGIS_texture_color_mask,
   GL_SGIS_texture_edge_clamp,
   GL_SGIS_texture_lod,

   GL_SGIX_depth_texture,
   GL_SGIX_shadow,
   GL_SGIX_shadow_ambient,

   GL_WIN_swap_hint,

   WGL_EXT_swap_control,
   WGL_ARB_multisample,
   WGL_ARB_extensions_string,
   WGL_ARB_pixel_format,
   WGL_ARB_pbuffer,
   WGL_ARB_buffer_region : Boolean;
//
// GLU
//
   GLU_VERSION_1_1 : Boolean;
   GLU_VERSION_1_2 : Boolean;
   GLU_VERSION_1_3 : Boolean;

   GLU_EXT_Texture          : Boolean;
   GLU_EXT_object_space_tess: Boolean;
   GLU_EXT_nurbs_tessellator: Boolean;
   
type
   HPBUFFERARB = Integer;

{$I 'svOpenGL1x/svGLConst.inc'}
{$I 'svOpenGL1x/svGLUConst.inc'}
{$I 'svOpenGL1x/svGLXConst.inc'}
{$I 'svOpenGL1x/svGLUTypes.inc'}

   // GL functions and procedures
   procedure glAccum(op: GLuint; value: GLfloat); stdcall; external opengl32;
   procedure glAlphaFunc(func: GLEnum; ref: GLclampf); stdcall; external opengl32;
   function  glAreTexturesResident(n: GLsizei; Textures: PGLuint; residences: PGLboolean): GLboolean; stdcall; external opengl32;
   procedure glArrayElement(i: GLint); stdcall; external opengl32;
   procedure glBegin(mode: GLEnum); stdcall; external opengl32;
   procedure glBindTexture(target: GLEnum; texture: GLuint); stdcall; external opengl32;
   procedure glBitmap(width: GLsizei; height: GLsizei; xorig, yorig: GLfloat; xmove: GLfloat; ymove: GLfloat; bitmap: Pointer); stdcall; external opengl32;
   procedure glBlendFunc(sfactor: GLEnum; dfactor: GLEnum); stdcall; external opengl32;
   procedure glCallList(list: GLuint); stdcall; external opengl32;
   procedure glCallLists(n: GLsizei; atype: GLEnum; lists: Pointer); stdcall; external opengl32;
   procedure glClear(mask: GLbitfield); stdcall; external opengl32;
   procedure glClearAccum(red, green, blue, alpha: GLfloat); stdcall; external opengl32;
   procedure glClearColor(red, green, blue, alpha: GLclampf); stdcall; external opengl32;
   procedure glClearDepth(depth: GLclampd); stdcall; external opengl32;
   procedure glClearIndex(c: GLfloat); stdcall; external opengl32;
   procedure glClearStencil(s: GLint ); stdcall; external opengl32;
   procedure glClipPlane(plane: GLEnum; equation: PGLdouble); stdcall; external opengl32;

   procedure glColor3b(red, green, blue: GLbyte); stdcall; external opengl32;
   procedure glColor3bv(v: PGLbyte); stdcall; external opengl32;
   procedure glColor3d(red, green, blue: GLdouble); stdcall; external opengl32;
   procedure glColor3dv(v: PGLdouble); stdcall; external opengl32;
   procedure glColor3f(red, green, blue: GLfloat); stdcall; external opengl32;
   procedure glColor3fv(v: PGLfloat); stdcall; external opengl32;
   procedure glColor3i(red, green, blue: GLint); stdcall; external opengl32;
   procedure glColor3iv(v: PGLint); stdcall; external opengl32;
   procedure glColor3s(red, green, blue: GLshort); stdcall; external opengl32;
   procedure glColor3sv(v: PGLshort); stdcall; external opengl32;
   procedure glColor3ub(red, green, blue: GLubyte); stdcall; external opengl32;
   procedure glColor3ubv(v: PGLubyte); stdcall; external opengl32;
   procedure glColor3ui(red, green, blue: GLuint); stdcall; external opengl32;
   procedure glColor3uiv(v: PGLuint); stdcall; external opengl32;
   procedure glColor3us(red, green, blue: GLushort); stdcall; external opengl32;
   procedure glColor3usv(v: PGLushort); stdcall; external opengl32;
   procedure glColor4b(red, green, blue, alpha: GLbyte); stdcall; external opengl32;
   procedure glColor4bv(v: PGLbyte); stdcall; external opengl32;
   procedure glColor4d(red, green, blue, alpha: GLdouble ); stdcall; external opengl32;
   procedure glColor4dv(v: PGLdouble); stdcall; external opengl32;
   procedure glColor4f(red, green, blue, alpha: GLfloat); stdcall; external opengl32;
   procedure glColor4fv(v: PGLfloat); stdcall; external opengl32;
   procedure glColor4i(red, green, blue, alpha: GLint); stdcall; external opengl32;
   procedure glColor4iv(v: PGLint); stdcall; external opengl32;
   procedure glColor4s(red, green, blue, alpha: GLshort); stdcall; external opengl32;
   procedure glColor4sv(v: GLshort); stdcall; external opengl32;
   procedure glColor4ub(red, green, blue, alpha: GLubyte); stdcall; external opengl32;
   procedure glColor4ubv(v: PGLubyte); stdcall; external opengl32;
   procedure glColor4ui(red, green, blue, alpha: GLuint); stdcall; external opengl32;
   procedure glColor4uiv(v: PGLuint); stdcall; external opengl32;
   procedure glColor4us(red, green, blue, alpha: GLushort); stdcall; external opengl32;
   procedure glColor4usv(v: PGLushort); stdcall; external opengl32;

   procedure glColorMask(red, green, blue, alpha: GLboolean); stdcall; external opengl32;
   procedure glColorMaterial(face: GLEnum; mode: GLEnum); stdcall; external opengl32;
   procedure glColorPointer(size: GLint; atype: GLEnum; stride: GLsizei; data: pointer); stdcall; external opengl32;
   procedure glCopyPixels(x, y: GLint; width, height: GLsizei; atype: GLEnum); stdcall; external opengl32;
   procedure glCopyTexImage1D(target: GLEnum; level: GLint; internalFormat: GLEnum; x, y: GLint; width: GLsizei; border: GLint); stdcall; external opengl32;
   procedure glCopyTexImage2D(target: GLEnum; level: GLint; internalFormat: GLEnum; x, y: GLint; width, height: GLsizei; border: GLint); stdcall; external opengl32;
   procedure glCopyTexSubImage1D(target: GLEnum; level, xoffset, x, y: GLint; width: GLsizei); stdcall; external opengl32;
   procedure glCopyTexSubImage2D(target: GLEnum; level, xoffset, yoffset, x, y: GLint; width, height: GLsizei); stdcall; external opengl32;
   procedure glCullFace(mode: GLEnum); stdcall; external opengl32;
   procedure glDeleteLists(list: GLuint; range: GLsizei); stdcall; external opengl32;
   procedure glDeleteTextures(n: GLsizei; textures: PGLuint); stdcall; external opengl32;
   procedure glDepthFunc(func: GLEnum); stdcall; external opengl32;
   procedure glDepthMask(flag: GLboolean); stdcall; external opengl32;
   procedure glDepthRange(zNear, zFar: GLclampd); stdcall; external opengl32;
   procedure glDisable(cap: GLEnum); stdcall; external opengl32;
   procedure glDisableClientState(aarray: GLEnum); stdcall; external opengl32;
   procedure glDrawArrays(mode: GLEnum; first: GLint; count: GLsizei); stdcall; external opengl32;
   procedure glDrawBuffer(mode: GLEnum); stdcall; external opengl32;
   procedure glDrawElements(mode: GLEnum; count: GLsizei; atype: GLEnum; indices: Pointer); stdcall; external opengl32;
   procedure glDrawPixels(width, height: GLsizei; format, atype: GLEnum; pixels: Pointer); stdcall; external opengl32;

   procedure glEdgeFlag(flag: GLboolean); stdcall; external opengl32;
   procedure glEdgeFlagPointer(stride: GLsizei; data: pointer); stdcall; external opengl32;
   procedure glEdgeFlagv(flag: PGLboolean); stdcall; external opengl32;
   procedure glEnable(cap: GLEnum); stdcall; external opengl32;
   procedure glEnableClientState(aarray: GLEnum); stdcall; external opengl32;
   procedure glEnd; stdcall; external opengl32;
   procedure glEndList; stdcall; external opengl32;
   procedure glEvalCoord1d(u: GLdouble); stdcall; external opengl32;
   procedure glEvalCoord1dv(u: PGLdouble); stdcall; external opengl32;
   procedure glEvalCoord1f(u: GLfloat); stdcall; external opengl32;
   procedure glEvalCoord1fv(u: PGLfloat); stdcall; external opengl32;
   procedure glEvalCoord2d(u: GLdouble; v: GLdouble); stdcall; external opengl32;
   procedure glEvalCoord2dv(u: PGLdouble); stdcall; external opengl32;
   procedure glEvalCoord2f(u, v: GLfloat); stdcall; external opengl32;
   procedure glEvalCoord2fv(u: PGLfloat); stdcall; external opengl32;
   procedure glEvalMesh1(mode: GLEnum; i1, i2: GLint); stdcall; external opengl32;
   procedure glEvalMesh2(mode: GLEnum; i1, i2, j1, j2: GLint); stdcall; external opengl32;
   procedure glEvalPoint1(i: GLint); stdcall; external opengl32;
   procedure glEvalPoint2(i, j: GLint); stdcall; external opengl32;

   procedure glFeedbackBuffer(size: GLsizei; atype: GLEnum; buffer: PGLfloat); stdcall; external opengl32;
   procedure glFinish; stdcall; external opengl32;
   procedure glFlush; stdcall; external opengl32;
   procedure glFogf(pname: GLEnum; param: GLfloat); stdcall; external opengl32;
   procedure glFogfv(pname: GLEnum; params: PGLfloat); stdcall; external opengl32;
   procedure glFogi(pname: GLEnum; param: GLint); stdcall; external opengl32;
   procedure glFogiv(pname: GLEnum; params: PGLint); stdcall; external opengl32;
   procedure glFrontFace(mode: GLEnum); stdcall; external opengl32;
   procedure glFrustum(left, right, bottom, top, zNear, zFar: GLdouble); stdcall; external opengl32;
   function  glGenLists(range: GLsizei): GLuint; stdcall; external opengl32;
   procedure glGenTextures(n: GLsizei; textures: PGLuint); stdcall; external opengl32;
   procedure glGetBooleanv(pname: GLEnum; params: PGLboolean); stdcall; external opengl32;
   procedure glGetClipPlane(plane: GLEnum; equation: PGLdouble); stdcall; external opengl32;
   procedure glGetDoublev(pname: GLEnum; params: PGLdouble); stdcall; external opengl32;
   function  glGetError: GLuint; stdcall; external opengl32;
   procedure glGetFloatv(pname: GLEnum; params: PGLfloat); stdcall; external opengl32;
   procedure glGetIntegerv(pname: GLEnum; params: PGLint); stdcall; external opengl32;
   procedure glGetLightfv(light, pname: GLEnum; params: PGLfloat); stdcall; external opengl32;
   procedure glGetLightiv(light, pname: GLEnum; params: PGLint); stdcall; external opengl32;
   procedure glGetMapdv(target, query: GLEnum; v: PGLdouble); stdcall; external opengl32;
   procedure glGetMapfv(target, query: GLEnum; v: PGLfloat); stdcall; external opengl32;
   procedure glGetMapiv(target, query: GLEnum; v: PGLint); stdcall; external opengl32;
   procedure glGetMaterialfv(face, pname: GLEnum; params: PGLfloat); stdcall; external opengl32;
   procedure glGetMaterialiv(face, pname: GLEnum; params: PGLint); stdcall; external opengl32;
   procedure glGetPixelMapfv(map: GLEnum; values: PGLfloat); stdcall; external opengl32;
   procedure glGetPixelMapuiv(map: GLEnum; values: PGLuint); stdcall; external opengl32;
   procedure glGetPixelMapusv(map: GLEnum; values: PGLushort); stdcall; external opengl32;
   procedure glGetPointerv(pname: GLEnum; var params); stdcall; external opengl32;
   procedure glGetPolygonStipple(mask: PGLubyte); stdcall; external opengl32;
   function  glGetString(name: GLEnum): PChar; stdcall; external opengl32;
   procedure glGetTexEnvfv(target, pname: GLEnum; params: PGLfloat); stdcall; external opengl32;
   procedure glGetTexEnviv(target, pname: GLEnum; params: PGLint); stdcall; external opengl32;
   procedure glGetTexGendv(coord, pname: GLEnum; params: PGLdouble); stdcall; external opengl32;
   procedure glGetTexGenfv(coord, pname: GLEnum; params: PGLfloat); stdcall; external opengl32;
   procedure glGetTexGeniv(coord, pname: GLEnum; params: PGLint); stdcall; external opengl32;
   procedure glGetTexImage(target: GLEnum; level: GLint; format, atype: GLEnum; pixels: Pointer); stdcall; external opengl32;
   procedure glGetTexLevelParameterfv(target: GLEnum; level: GLint; pname: GLEnum; params: PGLfloat); stdcall; external opengl32;
   procedure glGetTexLevelParameteriv(target: GLEnum; level: GLint; pname: GLEnum; params: PGLint); stdcall; external opengl32;
   procedure glGetTexParameterfv(target, pname: GLEnum; params: PGLfloat); stdcall; external opengl32;
   procedure glGetTexParameteriv(target, pname: GLEnum; params: PGLint); stdcall; external opengl32;

   procedure glHint(target, mode: GLEnum); stdcall; external opengl32;
   procedure glIndexMask(mask: GLuint); stdcall; external opengl32;
   procedure glIndexPointer(atype: GLEnum; stride: GLsizei; data: pointer); stdcall; external opengl32;
   procedure glIndexd(c: GLdouble); stdcall; external opengl32;
   procedure glIndexdv(c: PGLdouble); stdcall; external opengl32;
   procedure glIndexf(c: GLfloat); stdcall; external opengl32;
   procedure glIndexfv(c: PGLfloat); stdcall; external opengl32;
   procedure glIndexi(c: GLint); stdcall; external opengl32;
   procedure glIndexiv(c: PGLint); stdcall; external opengl32;
   procedure glIndexs(c: GLshort); stdcall; external opengl32;
   procedure glIndexsv(c: PGLshort); stdcall; external opengl32;
   procedure glIndexub(c: GLubyte); stdcall; external opengl32;
   procedure glIndexubv(c: PGLubyte); stdcall; external opengl32;
   procedure glInitNames; stdcall; external opengl32;
   procedure glInterleavedArrays(format: GLEnum; stride: GLsizei; data: pointer); stdcall; external opengl32;
   function  glIsEnabled(cap: GLEnum): GLboolean; stdcall; external opengl32;
   function  glIsList(list: GLuint): GLboolean; stdcall; external opengl32;
   function  glIsTexture(texture: GLuint): GLboolean; stdcall; external opengl32;
   procedure glLightModelf(pname: GLEnum; param: GLfloat); stdcall; external opengl32;
   procedure glLightModelfv(pname: GLEnum; params: PGLfloat); stdcall; external opengl32;
   procedure glLightModeli(pname: GLEnum; param: GLint); stdcall; external opengl32;
   procedure glLightModeliv(pname: GLEnum; params: PGLint); stdcall; external opengl32;
   procedure glLightf(light, pname: GLEnum; param: GLfloat); stdcall; external opengl32;
   procedure glLightfv(light, pname: GLEnum; params: PGLfloat); stdcall; external opengl32;
   procedure glLighti(light, pname: GLEnum; param: GLint); stdcall; external opengl32;
   procedure glLightiv(light, pname: GLEnum; params: PGLint); stdcall; external opengl32;
   procedure glLineStipple(factor: GLint; pattern: GLushort); stdcall; external opengl32;
   procedure glLineWidth(width: GLfloat); stdcall; external opengl32;
   procedure glListBase(base: GLuint); stdcall; external opengl32;
   procedure glLoadIdentity; stdcall; external opengl32;
   procedure glLoadMatrixd(m: PGLdouble); stdcall; external opengl32;
   procedure glLoadMatrixf(m: PGLfloat); stdcall; external opengl32;
   procedure glLoadName(name: GLuint); stdcall; external opengl32;
   procedure glLogicOp(opcode: GLEnum); stdcall; external opengl32;

   procedure glMap1d(target: GLEnum; u1, u2: GLdouble; stride, order: GLint; points: PGLdouble); stdcall; external opengl32;
   procedure glMap1f(target: GLEnum; u1, u2: GLfloat; stride, order: GLint; points: PGLfloat); stdcall; external opengl32;
   procedure glMap2d(target: GLEnum; u1, u2: GLdouble; ustride, uorder: GLint; v1, v2: GLdouble; vstride,
                     vorder: GLint; points: PGLdouble); stdcall; external opengl32;
   procedure glMap2f(target: GLEnum; u1, u2: GLfloat; ustride, uorder: GLint; v1, v2: GLfloat; vstride,
                     vorder: GLint; points: PGLfloat); stdcall; external opengl32;
   procedure glMapGrid1d(un: GLint; u1, u2: GLdouble); stdcall; external opengl32;
   procedure glMapGrid1f(un: GLint; u1, u2: GLfloat); stdcall; external opengl32;
   procedure glMapGrid2d(un: GLint; u1, u2: GLdouble; vn: GLint; v1, v2: GLdouble); stdcall; external opengl32;
   procedure glMapGrid2f(un: GLint; u1, u2: GLfloat; vn: GLint; v1, v2: GLfloat); stdcall; external opengl32;
   procedure glMaterialf(face, pname: GLEnum; param: GLfloat); stdcall; external opengl32;
   procedure glMaterialfv(face, pname: GLEnum; params: PGLfloat); stdcall; external opengl32;
   procedure glMateriali(face, pname: GLEnum; param: GLint); stdcall; external opengl32;
   procedure glMaterialiv(face, pname: GLEnum; params: PGLint); stdcall; external opengl32;
   procedure glMatrixMode(mode: GLEnum); stdcall; external opengl32;
   procedure glMultMatrixd(m: PGLdouble); stdcall; external opengl32;
   procedure glMultMatrixf(m: PGLfloat); stdcall; external opengl32;
   procedure glNewList(list: GLuint; mode: GLEnum); stdcall; external opengl32;
   procedure glNormal3b(nx, ny, nz: GLbyte); stdcall; external opengl32;
   procedure glNormal3bv(v: PGLbyte); stdcall; external opengl32;
   procedure glNormal3d(nx, ny, nz: GLdouble); stdcall; external opengl32;
   procedure glNormal3dv(v: PGLdouble); stdcall; external opengl32;
   procedure glNormal3f(nx, ny, nz: GLfloat); stdcall; external opengl32;
   procedure glNormal3fv(v: PGLfloat); stdcall; external opengl32;
   procedure glNormal3i(nx, ny, nz: GLint); stdcall; external opengl32;
   procedure glNormal3iv(v: PGLint); stdcall; external opengl32;
   procedure glNormal3s(nx, ny, nz: GLshort); stdcall; external opengl32;
   procedure glNormal3sv(v: PGLshort); stdcall; external opengl32;
   procedure glNormalPointer(atype: GLEnum; stride: GLsizei; data: pointer); stdcall; external opengl32;

   procedure glOrtho(left, right, bottom, top, zNear, zFar: GLdouble); stdcall; external opengl32;
   procedure glPassThrough(token: GLfloat); stdcall; external opengl32;
   procedure glPixelMapfv(map: GLEnum; mapsize: GLsizei; values: PGLfloat); stdcall; external opengl32;
   procedure glPixelMapuiv(map: GLEnum; mapsize: GLsizei; values: PGLuint); stdcall; external opengl32;
   procedure glPixelMapusv(map: GLEnum; mapsize: GLsizei; values: PGLushort); stdcall; external opengl32;
   procedure glPixelStoref(pname: GLEnum; param: GLfloat); stdcall; external opengl32;
   procedure glPixelStorei(pname: GLEnum; param: GLint); stdcall; external opengl32;
   procedure glPixelTransferf(pname: GLEnum; param: GLfloat); stdcall; external opengl32;
   procedure glPixelTransferi(pname: GLEnum; param: GLint); stdcall; external opengl32;
   procedure glPixelZoom(xfactor, yfactor: GLfloat); stdcall; external opengl32;
   procedure glPointSize(size: GLfloat); stdcall; external opengl32;
   procedure glPolygonMode(face, mode: GLEnum); stdcall; external opengl32;
   procedure glPolygonOffset(factor, units: GLfloat); stdcall; external opengl32;
   procedure glPolygonStipple(mask: PGLubyte); stdcall; external opengl32;
   procedure glPopAttrib; stdcall; external opengl32;
   procedure glPopClientAttrib; stdcall; external opengl32;
   procedure glPopMatrix; stdcall; external opengl32;
   procedure glPopName; stdcall; external opengl32;
   procedure glPrioritizeTextures(n: GLsizei; textures: PGLuint; priorities: PGLclampf); stdcall; external opengl32;
   procedure glPushAttrib(mask: GLbitfield); stdcall; external opengl32;
   procedure glPushClientAttrib(mask: GLbitfield); stdcall; external opengl32;
   procedure glPushMatrix; stdcall; external opengl32;
   procedure glPushName(name: GLuint); stdcall; external opengl32;

   procedure glRasterPos2d(x, y: GLdouble); stdcall; external opengl32;
   procedure glRasterPos2dv(v: PGLdouble); stdcall; external opengl32;
   procedure glRasterPos2f(x, y: GLfloat); stdcall; external opengl32;
   procedure glRasterPos2fv(v: PGLfloat); stdcall; external opengl32;
   procedure glRasterPos2i(x, y: GLint); stdcall; external opengl32;
   procedure glRasterPos2iv(v: PGLint); stdcall; external opengl32;
   procedure glRasterPos2s(x, y: PGLshort); stdcall; external opengl32;
   procedure glRasterPos2sv(v: PGLshort); stdcall; external opengl32;
   procedure glRasterPos3d(x, y, z: GLdouble); stdcall; external opengl32;
   procedure glRasterPos3dv(v: PGLdouble); stdcall; external opengl32;
   procedure glRasterPos3f(x, y, z: GLfloat); stdcall; external opengl32;
   procedure glRasterPos3fv(v: PGLfloat); stdcall; external opengl32;
   procedure glRasterPos3i(x, y, z: GLint); stdcall; external opengl32;
   procedure glRasterPos3iv(v: PGLint); stdcall; external opengl32;
   procedure glRasterPos3s(x, y, z: GLshort); stdcall; external opengl32;
   procedure glRasterPos3sv(v: PGLshort); stdcall; external opengl32;
   procedure glRasterPos4d(x, y, z, w: GLdouble); stdcall; external opengl32;
   procedure glRasterPos4dv(v: PGLdouble); stdcall; external opengl32;
   procedure glRasterPos4f(x, y, z, w: GLfloat); stdcall; external opengl32;
   procedure glRasterPos4fv(v: PGLfloat); stdcall; external opengl32;
   procedure glRasterPos4i(x, y, z, w: GLint); stdcall; external opengl32;
   procedure glRasterPos4iv(v: PGLint); stdcall; external opengl32;
   procedure glRasterPos4s(x, y, z, w: GLshort); stdcall; external opengl32;
   procedure glRasterPos4sv(v: PGLshort); stdcall; external opengl32;
   procedure glReadBuffer(mode: GLEnum); stdcall; external opengl32;
   procedure glReadPixels(x, y: GLint; width, height: GLsizei; format, atype: GLEnum; pixels: Pointer); stdcall; external opengl32;
   procedure glRectd(x1, y1, x2, y2: GLdouble); stdcall; external opengl32;
   procedure glRectdv(v1, v2: PGLdouble); stdcall; external opengl32;
   procedure glRectf(x1, y1, x2, y2: GLfloat); stdcall; external opengl32;
   procedure glRectfv(v1, v2: PGLfloat); stdcall; external opengl32;
   procedure glRecti(x1, y1, x2, y2: GLint); stdcall; external opengl32;
   procedure glRectiv(v1, v2: PGLint); stdcall; external opengl32;
   procedure glRects(x1, y1, x2, y2: GLshort); stdcall; external opengl32;
   procedure glRectsv(v1, v2: PGLshort); stdcall; external opengl32;
   function  glRenderMode(mode: GLEnum): GLint; stdcall; external opengl32;
   procedure glRotated(angle, x, y, z: GLdouble); stdcall; external opengl32;
   procedure glRotatef(angle, x, y, z: GLfloat); stdcall; external opengl32;

   procedure glScaled(x, y, z: GLdouble); stdcall; external opengl32;
   procedure glScalef(x, y, z: GLfloat); stdcall; external opengl32;
   procedure glScissor(x, y: GLint; width, height: GLsizei); stdcall; external opengl32;
   procedure glSelectBuffer(size: GLsizei; buffer: PGLuint); stdcall; external opengl32;
   procedure glShadeModel(mode: GLEnum); stdcall; external opengl32;
   procedure glStencilFunc(func: GLEnum; ref: GLint; mask: GLuint); stdcall; external opengl32;
   procedure glStencilMask(mask: GLuint); stdcall; external opengl32;
   procedure glStencilOp(fail, zfail, zpass: GLEnum); stdcall; external opengl32;
   procedure glTexCoord1d(s: GLdouble); stdcall; external opengl32;
   procedure glTexCoord1dv(v: PGLdouble); stdcall; external opengl32;
   procedure glTexCoord1f(s: GLfloat); stdcall; external opengl32;
   procedure glTexCoord1fv(v: PGLfloat); stdcall; external opengl32;
   procedure glTexCoord1i(s: GLint); stdcall; external opengl32;
   procedure glTexCoord1iv(v: PGLint); stdcall; external opengl32;
   procedure glTexCoord1s(s: GLshort); stdcall; external opengl32;
   procedure glTexCoord1sv(v: PGLshort); stdcall; external opengl32;
   procedure glTexCoord2d(s, t: GLdouble); stdcall; external opengl32;
   procedure glTexCoord2dv(v: PGLdouble); stdcall; external opengl32;
   procedure glTexCoord2f(s, t: GLfloat); stdcall; external opengl32;
   procedure glTexCoord2fv(v: PGLfloat); stdcall; external opengl32;
   procedure glTexCoord2i(s, t: GLint); stdcall; external opengl32;
   procedure glTexCoord2iv(v: PGLint); stdcall; external opengl32;
   procedure glTexCoord2s(s, t: GLshort); stdcall; external opengl32;
   procedure glTexCoord2sv(v: PGLshort); stdcall; external opengl32;
   procedure glTexCoord3d(s, t, r: GLdouble); stdcall; external opengl32;
   procedure glTexCoord3dv(v: PGLdouble); stdcall; external opengl32;
   procedure glTexCoord3f(s, t, r: GLfloat); stdcall; external opengl32;
   procedure glTexCoord3fv(v: PGLfloat); stdcall; external opengl32;
   procedure glTexCoord3i(s, t, r: GLint); stdcall; external opengl32;
   procedure glTexCoord3iv(v: PGLint); stdcall; external opengl32;
   procedure glTexCoord3s(s, t, r: GLshort); stdcall; external opengl32;
   procedure glTexCoord3sv(v: PGLshort); stdcall; external opengl32;
   procedure glTexCoord4d(s, t, r, q: GLdouble); stdcall; external opengl32;
   procedure glTexCoord4dv(v: PGLdouble); stdcall; external opengl32;
   procedure glTexCoord4f(s, t, r, q: GLfloat); stdcall; external opengl32;
   procedure glTexCoord4fv(v: PGLfloat); stdcall; external opengl32;
   procedure glTexCoord4i(s, t, r, q: GLint); stdcall; external opengl32;
   procedure glTexCoord4iv(v: PGLint); stdcall; external opengl32;
   procedure glTexCoord4s(s, t, r, q: GLshort); stdcall; external opengl32;
   procedure glTexCoord4sv(v: PGLshort); stdcall; external opengl32;
   procedure glTexCoordPointer(size: GLint; atype: GLEnum; stride: GLsizei; data: pointer); stdcall; external opengl32;
   procedure glTexEnvf(target, pname: GLEnum; param: GLfloat); stdcall; external opengl32;
   procedure glTexEnvfv(target, pname: GLEnum; params: PGLfloat); stdcall; external opengl32;
   procedure glTexEnvi(target, pname: GLEnum; param: GLint); stdcall; external opengl32;
   procedure glTexEnviv(target, pname: GLEnum; params: PGLint); stdcall; external opengl32;
   procedure glTexGend(coord, pname: GLEnum; param: GLdouble); stdcall; external opengl32;
   procedure glTexGendv(coord, pname: GLEnum; params: PGLdouble); stdcall; external opengl32;
   procedure glTexGenf(coord, pname: GLEnum; param: GLfloat); stdcall; external opengl32;
   procedure glTexGenfv(coord, pname: GLEnum; params: PGLfloat); stdcall; external opengl32;
   procedure glTexGeni(coord, pname: GLEnum; param: GLint); stdcall; external opengl32;
   procedure glTexGeniv(coord, pname: GLEnum; params: PGLint); stdcall; external opengl32;
   procedure glTexImage1D(target: GLEnum; level, internalformat: GLint; width: GLsizei; border: GLint; format,
                          atype: GLEnum; pixels: Pointer); stdcall; external opengl32;
   procedure glTexImage2D(target: GLEnum; level, internalformat: GLint; width, height: GLsizei; border: GLint;
                          format, atype: GLEnum; Pixels:Pointer); stdcall; external opengl32;
   procedure glTexParameterf(target, pname: GLEnum; param: GLfloat); stdcall; external opengl32;
   procedure glTexParameterfv(target, pname: GLEnum; params: PGLfloat); stdcall; external opengl32;
   procedure glTexParameteri(target, pname: GLEnum; param: GLint); stdcall; external opengl32;
   procedure glTexParameteriv(target, pname: GLEnum; params: PGLint); stdcall; external opengl32;
   procedure glTexSubImage1D(target: GLEnum; level, xoffset: GLint; width: GLsizei; format, atype: GLEnum;
                             pixels: Pointer); stdcall; external opengl32;
   procedure glTexSubImage2D(target: GLEnum; level, xoffset, yoffset: GLint; width, height: GLsizei; format,
                             atype: GLEnum; pixels: Pointer); stdcall; external opengl32;
   procedure glTranslated(x, y, z: GLdouble); stdcall; external opengl32;
   procedure glTranslatef(x, y, z: GLfloat); stdcall; external opengl32;

   procedure glVertex2d(x, y: GLdouble); stdcall; external opengl32;
   procedure glVertex2dv(v: PGLdouble); stdcall; external opengl32;
   procedure glVertex2f(x, y: GLfloat); stdcall; external opengl32;
   procedure glVertex2fv(v: PGLfloat); stdcall; external opengl32;
   procedure glVertex2i(x, y: GLint); stdcall; external opengl32;
   procedure glVertex2iv(v: PGLint); stdcall; external opengl32;
   procedure glVertex2s(x, y: GLshort); stdcall; external opengl32;
   procedure glVertex2sv(v: PGLshort); stdcall; external opengl32;
   procedure glVertex3d(x, y, z: GLdouble); stdcall; external opengl32;
   procedure glVertex3dv(v: PGLdouble); stdcall; external opengl32;
   procedure glVertex3f(x, y, z: GLfloat); stdcall; external opengl32;
   procedure glVertex3fv(v: PGLfloat); stdcall; external opengl32;
   procedure glVertex3i(x, y, z: GLint); stdcall; external opengl32;
   procedure glVertex3iv(v: PGLint); stdcall; external opengl32;
   procedure glVertex3s(x, y, z: GLshort); stdcall; external opengl32;
   procedure glVertex3sv(v: PGLshort); stdcall; external opengl32;
   procedure glVertex4d(x, y, z, w: GLdouble); stdcall; external opengl32;
   procedure glVertex4dv(v: PGLdouble); stdcall; external opengl32;
   procedure glVertex4f(x, y, z, w: GLfloat); stdcall; external opengl32;
   procedure glVertex4fv(v: PGLfloat); stdcall; external opengl32;
   procedure glVertex4i(x, y, z, w: GLint); stdcall; external opengl32;
   procedure glVertex4iv(v: PGLint); stdcall; external opengl32;
   procedure glVertex4s(x, y, z, w: GLshort); stdcall; external opengl32;
   procedure glVertex4sv(v: PGLshort); stdcall; external opengl32;
   procedure glVertexPointer(size: GLint; atype: GLEnum; stride: GLsizei; data: pointer); stdcall; external opengl32;
   procedure glViewport(x, y: GLint; width, height: GLsizei); stdcall; external opengl32;

   // GL utility functions and procedures
   function  gluErrorString(errCode: GLEnum): PChar; stdcall; external glu32;
   function  gluGetString(name: GLEnum): PChar; stdcall; external glu32;
   procedure gluOrtho2D(left, right, bottom, top: GLdouble); stdcall; external glu32;
   procedure gluPerspective(fovy, aspect, zNear, zFar: GLdouble); stdcall; external glu32;
   procedure gluPickMatrix(x, y, width, height: GLdouble; viewport: TVector4i); stdcall; external glu32;
   procedure gluLookAt(eyex, eyey, eyez, centerx, centery, centerz, upx, upy, upz: GLdouble); stdcall; external glu32;
   function  gluProject(objx, objy, objz: GLdouble; modelMatrix: TMatrix4d; projMatrix: TMatrix4d; viewport: TVector4i;
                        winx, winy, winz: PGLdouble): GLint; stdcall; external glu32;
   function  gluUnProject(winx, winy, winz: GLdouble; modelMatrix: TMatrix4d; projMatrix: TMatrix4d; viewport: TVector4i;
                          objx, objy, objz: PGLdouble): GLint; stdcall; external glu32;
   function  gluScaleImage(format: GLEnum; widthin, heightin: GLint; typein: GLEnum; datain: Pointer; widthout,
                           heightout: GLint; typeout: GLEnum; dataout: Pointer): GLint; stdcall; external glu32;
   function  gluBuild1DMipmaps(target: GLEnum; components, width: GLint; format, atype: GLEnum;
                               data: Pointer): GLint; stdcall; external glu32;
   function  gluBuild2DMipmaps(target: GLEnum; components, width, height: GLint; format, atype: GLEnum;
                               data: Pointer): GLint; stdcall; external glu32;
   function  gluNewQuadric: PGLUquadric; stdcall; external glu32;
   procedure gluDeleteQuadric(state: PGLUquadric); stdcall; external glu32;
   procedure gluQuadricNormals(quadObject: PGLUquadric; normals: GLEnum); stdcall; external glu32;
   procedure gluQuadricTexture(quadObject: PGLUquadric; textureCoords: GLboolean); stdcall; external glu32;
   procedure gluQuadricOrientation(quadObject: PGLUquadric; orientation: GLEnum); stdcall; external glu32;
   procedure gluQuadricDrawStyle(quadObject: PGLUquadric; drawStyle: GLEnum); stdcall; external glu32;
   procedure gluCylinder(quadObject: PGLUquadric; baseRadius, topRadius, height: GLdouble; slices,
                         stacks: GLint); stdcall; external glu32;
   procedure gluDisk(quadObject: PGLUquadric; innerRadius, outerRadius: GLdouble; slices, loops: GLint); stdcall; external glu32;
   procedure gluPartialDisk(quadObject: PGLUquadric; innerRadius, outerRadius: GLdouble; slices, loops: GLint;
                            startAngle, sweepAngle: GLdouble); stdcall; external glu32;
   procedure gluSphere(quadObject: PGLUquadric; radius: GLdouble; slices, stacks: GLint); stdcall; external glu32;
   procedure gluQuadricCallback(quadObject: PGLUquadric; which: GLEnum; fn: GLUQuadricErrorProc); stdcall; external glu32;
   function  gluNewTess: PGLUtesselator; stdcall; external glu32;
   procedure gluDeleteTess(tess: PGLUtesselator); stdcall; external glu32;
   procedure gluTessBeginPolygon(tess: PGLUtesselator; polygon_data: Pointer); stdcall; external glu32;
   procedure gluTessBeginContour(tess: PGLUtesselator); stdcall; external glu32;
   procedure gluTessVertex(tess: PGLUtesselator; coords: TVector3d; data: Pointer); stdcall; external glu32;
   procedure gluTessEndContour(tess: PGLUtesselator); stdcall; external glu32;
   procedure gluTessEndPolygon(tess: PGLUtesselator); stdcall; external glu32;
   procedure gluTessProperty(tess: PGLUtesselator; which: GLEnum; value: GLdouble); stdcall; external glu32;
   procedure gluTessNormal(tess: PGLUtesselator; x, y, z: GLdouble); stdcall; external glu32;
   procedure gluTessCallback(tess: PGLUtesselator; which: GLEnum; fn: Pointer); stdcall; external glu32;
   procedure gluGetTessProperty(tess: PGLUtesselator; which: GLEnum; value: PGLdouble); stdcall; external glu32;
   function  gluNewNurbsRenderer: PGLUnurbs; stdcall; external glu32;
   procedure gluDeleteNurbsRenderer(nobj: PGLUnurbs); stdcall; external glu32;
   procedure gluBeginSurface(nobj: PGLUnurbs); stdcall; external glu32;
   procedure gluBeginCurve(nobj: PGLUnurbs); stdcall; external glu32;
   procedure gluEndCurve(nobj: PGLUnurbs); stdcall; external glu32;
   procedure gluEndSurface(nobj: PGLUnurbs); stdcall; external glu32;
   procedure gluBeginTrim(nobj: PGLUnurbs); stdcall; external glu32;
   procedure gluEndTrim(nobj: PGLUnurbs); stdcall; external glu32;
   procedure gluPwlCurve(nobj: PGLUnurbs; count: GLint; points: PGLfloat; stride: GLint; atype: GLEnum); stdcall; external glu32;
   procedure gluNurbsCurve(nobj: PGLUnurbs; nknots: GLint; knot: PGLfloat; stride: GLint; ctlarray: PGLfloat; order: GLint; atype: GLEnum); stdcall; external glu32;
   procedure gluNurbsSurface(nobj: PGLUnurbs; sknot_count: GLint; sknot: PGLfloat; tknot_count: GLint; tknot: PGLfloat; s_stride, t_stride: GLint; ctlarray: PGLfloat; sorder, torder: GLint; atype: GLEnum); stdcall; external glu32;
   procedure gluLoadSamplingMatrices(nobj: PGLUnurbs; modelMatrix, projMatrix: TMatrix4f; viewport: TVector4i); stdcall; external glu32;
   procedure gluNurbsProperty(nobj: PGLUnurbs; aproperty: GLEnum; value: GLfloat); stdcall; external glu32;
   procedure gluGetNurbsProperty(nobj: PGLUnurbs; aproperty: GLEnum; value: PGLfloat); stdcall; external glu32;
   procedure gluNurbsCallback(nobj: PGLUnurbs; which: GLEnum; fn: GLUNurbsErrorProc); stdcall; external glu32;
   procedure gluBeginPolygon(tess: PGLUtesselator); stdcall; external glu32;
   procedure gluNextContour(tess: PGLUtesselator; atype: GLEnum); stdcall; external glu32;
   procedure gluEndPolygon(tess: PGLUtesselator); stdcall; external glu32;

   // window support functions
   {$ifdef MSWINDOWS}
   function wglGetProcAddress(ProcName: PChar): Pointer; stdcall; external opengl32;
   function wglCopyContext(p1: HGLRC; p2: HGLRC; p3: Cardinal): BOOL; stdcall; external opengl32;
   function wglCreateContext(DC: HDC): HGLRC; stdcall; external opengl32;
   function wglCreateLayerContext(p1: HDC; p2: Integer): HGLRC; stdcall; external opengl32;
   function wglDeleteContext(p1: HGLRC): BOOL; stdcall; external opengl32;
   function wglDescribeLayerPlane(p1: HDC; p2, p3: Integer; p4: Cardinal; var p5: TLayerPlaneDescriptor): BOOL; stdcall; external opengl32;
   function wglGetCurrentContext: HGLRC; stdcall; external opengl32;
   function wglGetCurrentDC: HDC; stdcall; external opengl32;
   function wglGetLayerPaletteEntries(p1: HDC; p2, p3, p4: Integer; var pcr): Integer; stdcall; external opengl32;
   function wglMakeCurrent(DC: HDC; p2: HGLRC): BOOL; stdcall; external opengl32;
   function wglRealizeLayerPalette(p1: HDC; p2: Integer; p3: BOOL): BOOL; stdcall; external opengl32;
   function wglSetLayerPaletteEntries(p1: HDC; p2, p3, p4: Integer; var pcr): Integer; stdcall; external opengl32;
   function wglShareLists(p1, p2: HGLRC): BOOL; stdcall; external opengl32;
   function wglSwapLayerBuffers(p1: HDC; p2: Cardinal): BOOL; stdcall; external opengl32;
   function wglSwapMultipleBuffers(p1: UINT; const p2: PWGLSwap): DWORD; stdcall; external opengl32;
   function wglUseFontBitmapsA(DC: HDC; p2, p3, p4: DWORD): BOOL; stdcall; external opengl32;
   function wglUseFontOutlinesA (p1: HDC; p2, p3, p4: DWORD; p5, p6: Single; p7: Integer; p8: PGlyphMetricsFloat): BOOL; stdcall; external opengl32;
   function wglUseFontBitmapsW(DC: HDC; p2, p3, p4: DWORD): BOOL; stdcall; external opengl32;
   function wglUseFontOutlinesW (p1: HDC; p2, p3, p4: DWORD; p5, p6: Single; p7: Integer; p8: PGlyphMetricsFloat): BOOL; stdcall; external opengl32;
   function wglUseFontBitmaps(DC: HDC; p2, p3, p4: DWORD): BOOL; stdcall; external opengl32 name 'wglUseFontBitmapsA';
   function wglUseFontOutlines(p1: HDC; p2, p3, p4: DWORD; p5, p6: Single; p7: Integer; p8: PGlyphMetricsFloat): BOOL; stdcall; external opengl32 name 'wglUseFontOutlinesA';
   {$endif}

var
   // GL 1.2
   glDrawRangeElements: procedure(mode: GLEnum; Astart, Aend: GLuint; count: GLsizei; Atype: GLEnum;
                                  indices: Pointer); stdcall;
   glTexImage3D: procedure(target: GLEnum; level: GLint; internalformat: GLEnum; width, height, depth: GLsizei;
                           border: GLint; format: GLEnum; Atype: GLEnum; pixels: Pointer); stdcall;

   // GL 1.2 ARB imaging
   glBlendColor: procedure(red, green, blue, alpha: GLclampf); stdcall;
   glBlendEquation: procedure(mode: GLEnum); stdcall;
   glColorSubTable: procedure(target: GLEnum; start, count: GLsizei; format, Atype: GLEnum; data: Pointer); stdcall;
   glCopyColorSubTable: procedure(target: GLEnum; start: GLsizei; x, y: GLint; width: GLsizei); stdcall;
   glColorTable: procedure(target, internalformat: GLEnum; width: GLsizei; format, Atype: GLEnum;
     table: Pointer); stdcall;
   glCopyColorTable: procedure(target, internalformat: GLEnum; x, y: GLint; width: GLsizei); stdcall;
   glColorTableParameteriv: procedure(target, pname: GLEnum; params: PGLint); stdcall;
   glColorTableParameterfv: procedure(target, pname: GLEnum; params: PGLfloat); stdcall;
   glGetColorTable: procedure(target, format, Atype: GLEnum; table: Pointer); stdcall;
   glGetColorTableParameteriv: procedure(target, pname: GLEnum; params: PGLint); stdcall;
   glGetColorTableParameterfv: procedure(target, pname: GLEnum; params: PGLfloat); stdcall;
   glConvolutionFilter1D: procedure(target, internalformat: GLEnum; width: GLsizei; format, Atype: GLEnum;
     image: Pointer); stdcall;
   glConvolutionFilter2D: procedure(target, internalformat: GLEnum; width, height: GLsizei; format, Atype: GLEnum;
     image: Pointer); stdcall;
   glCopyConvolutionFilter1D: procedure(target, internalformat: GLEnum; x, y: GLint; width: GLsizei); stdcall;
   glCopyConvolutionFilter2D: procedure(target, internalformat: GLEnum; x, y: GLint; width, height: GLsizei); stdcall;
   glGetConvolutionFilter: procedure(target, internalformat, Atype: GLEnum; image: Pointer); stdcall;
   glSeparableFilter2D: procedure(target, internalformat: GLEnum; width, height: GLsizei; format, Atype: GLEnum; row,
     column: Pointer); stdcall;
   glGetSeparableFilter: procedure(target, format, Atype: GLEnum; row, column, span: Pointer); stdcall;
   glConvolutionParameteri: procedure(target, pname: GLEnum; param: GLint); stdcall;
   glConvolutionParameteriv: procedure(target, pname: GLEnum; params: PGLint); stdcall;
   glConvolutionParameterf: procedure(target, pname: GLEnum; param: GLfloat); stdcall;
   glConvolutionParameterfv: procedure(target, pname: GLEnum; params: PGLfloat); stdcall;
   glGetConvolutionParameteriv: procedure(target, pname: GLEnum; params: PGLint); stdcall;
   glGetConvolutionParameterfv: procedure(target, pname: GLEnum; params: PGLfloat); stdcall;
   glHistogram: procedure(target: GLEnum; width: GLsizei; internalformat: GLEnum; sink: GLboolean); stdcall;
   glResetHistogram: procedure(target: GLEnum); stdcall;
   glGetHistogram: procedure(target: GLEnum; reset: GLboolean; format, Atype: GLEnum; values: Pointer); stdcall;
   glGetHistogramParameteriv: procedure(target, pname: GLEnum; params: PGLint); stdcall;
   glGetHistogramParameterfv: procedure(target, pname: GLEnum; params: PGLfloat); stdcall;
   glMinmax: procedure(target, internalformat: GLEnum; sink: GLboolean); stdcall;
   glResetMinmax: procedure(target: GLEnum); stdcall;
   glGetMinmax: procedure(target: GLEnum; reset: GLboolean; format, Atype: GLEnum; values: Pointer); stdcall;
   glGetMinmaxParameteriv: procedure(target, pname: GLEnum; params: PGLint); stdcall;
   glGetMinmaxParameterfv: procedure(target, pname: GLEnum; params: PGLfloat); stdcall;

   {$ifdef MSWINDOWS}
   // ARB wgl extensions
   wglGetExtensionsStringARB: function(DC: HDC): PChar; stdcall;
   wglGetPixelFormatAttribivARB: function(DC: HDC; iPixelFormat, iLayerPlane: Integer; nAttributes: GLEnum;
     const piAttributes: PGLint; piValues : PGLint) : BOOL; stdcall;
   wglGetPixelFormatAttribfvARB: function(DC: HDC; iPixelFormat, iLayerPlane: Integer; nAttributes: GLEnum;
     const piAttributes: PGLint; piValues: PGLFloat) : BOOL; stdcall;
   wglChoosePixelFormatARB: function(DC: HDC; const piAttribIList: PGLint; const pfAttribFList: PGLFloat;
     nMaxFormats: GLint; piFormats: PGLint; nNumFormats: PGLenum) : BOOL; stdcall;
   wglCreatePbufferARB: function(DC: HDC; iPixelFormat: Integer; iWidth, iHeight : Integer;
     const piAttribList: PGLint) : HPBUFFERARB; stdcall;
   wglGetPbufferDCARB: function(hPbuffer: HPBUFFERARB) : HDC; stdcall;
   wglReleasePbufferDCARB: function(hPbuffer: HPBUFFERARB; DC: HDC) : Integer; stdcall;
   wglDestroyPbufferARB: function(hPbuffer: HPBUFFERARB): BOOL; stdcall;
   wglQueryPbufferARB: function(hPbuffer: HPBUFFERARB; iAttribute : Integer;
     piValue: PGLint) : BOOL; stdcall;

   wglCreateBufferRegionARB: function(DC: HDC; iLayerPlane: Integer; uType: GLEnum) : Integer; stdcall;
   wglDeleteBufferRegionARB: procedure(hRegion: Integer); stdcall;
   wglSaveBufferRegionARB: function(hRegion: Integer; x, y, width, height: Integer): BOOL; stdcall;
   wglRestoreBufferRegionARB: function(hRegion: Integer; x, y, width, height: Integer;
     xSrc, ySrc: Integer): BOOL; stdcall;

   // non-ARB wgl extensions
   wglSwapIntervalEXT: function(interval : Integer) : BOOL; stdcall;
   wglGetSwapIntervalEXT: function : Integer; stdcall;

   {$endif}

   // ARB_multitexture
   glMultiTexCoord1dARB: procedure(target: GLEnum; s: GLdouble); stdcall;
   glMultiTexCoord1dVARB: procedure(target: GLEnum; v: PGLdouble); stdcall;
   glMultiTexCoord1fARBP: procedure(target: GLEnum; s: GLfloat); stdcall;
   glMultiTexCoord1fVARB: procedure(target: GLEnum; v: GLfloat); stdcall;
   glMultiTexCoord1iARB: procedure(target: GLEnum; s: GLint); stdcall;
   glMultiTexCoord1iVARB: procedure(target: GLEnum; v: PGLInt); stdcall;
   glMultiTexCoord1sARBP: procedure(target: GLEnum; s: GLshort); stdcall;
   glMultiTexCoord1sVARB: procedure(target: GLEnum; v: PGLshort); stdcall;
   glMultiTexCoord2dARB: procedure(target: GLEnum; s, t: GLdouble); stdcall;
   glMultiTexCoord2dvARB: procedure(target: GLEnum; v: PGLdouble); stdcall;
   glMultiTexCoord2fARB: procedure(target: GLEnum; s, t: GLfloat); stdcall;
   glMultiTexCoord2fvARB: procedure(target: GLEnum; v: PGLfloat); stdcall;
   glMultiTexCoord2iARB: procedure(target: GLEnum; s, t: GLint); stdcall;
   glMultiTexCoord2ivARB: procedure(target: GLEnum; v: PGLint); stdcall;
   glMultiTexCoord2sARB: procedure(target: GLEnum; s, t: GLshort); stdcall;
   glMultiTexCoord2svARB: procedure(target: GLEnum; v: PGLshort); stdcall;
   glMultiTexCoord3dARB: procedure(target: GLEnum; s, t, r: GLdouble); stdcall;
   glMultiTexCoord3dvARB: procedure(target: GLEnum; v: PGLdouble); stdcall;
   glMultiTexCoord3fARB: procedure(target: GLEnum; s, t, r: GLfloat); stdcall;
   glMultiTexCoord3fvARB: procedure(target: GLEnum; v: PGLfloat); stdcall;
   glMultiTexCoord3iARB: procedure(target: GLEnum; s, t, r: GLint); stdcall;
   glMultiTexCoord3ivARB: procedure(target: GLEnum; v: PGLint); stdcall;
   glMultiTexCoord3sARB: procedure(target: GLEnum; s, t, r: GLshort); stdcall;
   glMultiTexCoord3svARB: procedure(target: GLEnum; v: PGLshort); stdcall;
   glMultiTexCoord4dARB: procedure(target: GLEnum; s, t, r, q: GLdouble); stdcall;
   glMultiTexCoord4dvARB: procedure(target: GLEnum; v: PGLdouble); stdcall;
   glMultiTexCoord4fARB: procedure(target: GLEnum; s, t, r, q: GLfloat); stdcall;
   glMultiTexCoord4fvARB: procedure(target: GLEnum; v: PGLfloat); stdcall;
   glMultiTexCoord4iARB: procedure(target: GLEnum; s, t, r, q: GLint); stdcall;
   glMultiTexCoord4ivARB: procedure(target: GLEnum; v: PGLint); stdcall;
   glMultiTexCoord4sARB: procedure(target: GLEnum; s, t, r, q: GLshort); stdcall;
   glMultiTexCoord4svARB: procedure(target: GLEnum; v: PGLshort); stdcall;
   glActiveTextureARB: procedure(target: GLEnum); stdcall;
   glClientActiveTextureARB: procedure(target: GLEnum); stdcall;

   // GLU extensions
   gluNurbsCallbackDataEXT: procedure(nurb: PGLUnurbs; userData: Pointer); stdcall;
   gluNewNurbsTessellatorEXT: function: PGLUnurbs; stdcall;
   gluDeleteNurbsTessellatorEXT: procedure(nurb: PGLUnurbs); stdcall;

   // Extension functions
   glAreTexturesResidentEXT: function(n: GLsizei; textures: PGLuint; residences: PGLBoolean): GLboolean; stdcall;
   glArrayElementArrayEXT: procedure(mode: GLEnum; count: GLsizei; pi: Pointer); stdcall;
   glBeginSceneEXT: procedure; stdcall;
   glBindTextureEXT: procedure(target: GLEnum; texture: GLuint); stdcall;
   glColorTableEXT: procedure(target, internalFormat: GLEnum; width: GLsizei; format, atype: GLEnum; data: Pointer); stdcall;
   glColorSubTableExt: procedure(target: GLEnum; start, count: GLsizei; format, atype: GLEnum; data: Pointer); stdcall;
   glCopyTexImage1DEXT: procedure(target: GLEnum; level: GLint; internalFormat: GLEnum; x, y: GLint; width: GLsizei; border: GLint); stdcall;
   glCopyTexSubImage1DEXT: procedure(target: GLEnum; level, xoffset, x, y: GLint; width: GLsizei); stdcall;
   glCopyTexImage2DEXT: procedure(target: GLEnum; level: GLint; internalFormat: GLEnum; x, y: GLint; width, height: GLsizei; border: GLint); stdcall;
   glCopyTexSubImage2DEXT: procedure(target: GLEnum; level, xoffset, yoffset, x, y: GLint; width, height: GLsizei); stdcall;
   glCopyTexSubImage3DEXT: procedure(target: GLEnum; level, xoffset, yoffset, zoffset, x, y: GLint; width, height: GLsizei); stdcall;
   glDeleteTexturesEXT: procedure(n: GLsizei; textures: PGLuint); stdcall;
   glEndSceneEXT: procedure; stdcall;
   glGenTexturesEXT: procedure(n: GLsizei; textures: PGLuint); stdcall;
   glGetColorTableEXT: procedure(target, format, atype: GLEnum; data: Pointer); stdcall;
   glGetColorTablePameterfvEXT: procedure(target, pname: GLEnum; params: Pointer); stdcall;
   glGetColorTablePameterivEXT: procedure(target, pname: GLEnum; params: Pointer); stdcall;
   glIndexFuncEXT: procedure(func: GLEnum; ref: GLfloat); stdcall;
   glIndexMaterialEXT: procedure(face: GLEnum; mode: GLEnum); stdcall;
   glIsTextureEXT: function(texture: GLuint): GLboolean; stdcall;
   glPolygonOffsetEXT: procedure(factor, bias: GLfloat); stdcall;
   glPrioritizeTexturesEXT: procedure(n: GLsizei; textures: PGLuint; priorities: PGLclampf); stdcall;
   glTexSubImage1DEXT: procedure(target: GLEnum; level, xoffset: GLint; width: GLsizei; format, Atype: GLEnum; pixels: Pointer); stdcall;
   glTexSubImage2DEXT: procedure(target: GLEnum; level, xoffset, yoffset: GLint; width, height: GLsizei; format, Atype: GLEnum; pixels: Pointer); stdcall;
   glTexSubImage3DEXT: procedure(target: GLEnum; level, xoffset, yoffset, zoffset: GLint; width, height, depth: GLsizei; format, Atype: GLEnum; pixels: Pointer); stdcall;

   // EXT_compiled_vertex_array
   glLockArraysEXT: procedure(first: GLint; count: GLsizei); stdcall;
   glUnlockArraysEXT: procedure; stdcall;

   // EXT_vertex_array
   glArrayElementEXT: procedure(I: GLint); stdcall;
   glColorPointerEXT: procedure(size: GLint; atype: GLEnum; stride, count: GLsizei; data: Pointer); stdcall;
   glDrawArraysEXT: procedure(mode: GLEnum; first: GLint; count: GLsizei); stdcall;
   glEdgeFlagPointerEXT: procedure(stride, count: GLsizei; data: PGLboolean); stdcall;
   glGetPointervEXT: procedure(pname: GLEnum; var params); stdcall;
   glIndexPointerEXT: procedure(AType: GLEnum; stride, count: GLsizei; P: Pointer); stdcall;
   glNormalPointerEXT: procedure(AType: GLsizei; stride, count: GLsizei; P: Pointer); stdcall;
   glTexCoordPointerEXT: procedure(size: GLint; AType: GLEnum;  stride, count: GLsizei; P: Pointer); stdcall;
   glVertexPointerEXT: procedure(size: GLint; AType: GLEnum; stride, count: GLsizei; P: Pointer); stdcall;

   // EXT_stencil_two_side
   glActiveStencilFaceEXT: procedure(face: GLEnum); stdcall;

   // WIN_swap_hint
   glAddSwapHintRectWIN: procedure(x, y: GLint; width, height: GLsizei); stdcall;

   // GL_ARB_point_parameter
   glPointParameterfARB: procedure(pname: GLEnum; param: GLfloat); stdcall;
   glPointParameterfvARB: procedure(pname: GLEnum; params: PGLfloat); stdcall;

   // GL_ARB_transpose_matrix
   glLoadTransposeMatrixfARB: procedure(m: PGLfloat); stdcall;
   glLoadTransposeMatrixdARB: procedure(m: PGLdouble); stdcall;
   glMultTransposeMatrixfARB: procedure(m: PGLfloat); stdcall;
   glMultTransposeMatrixdARB: procedure(m: PGLdouble); stdcall;

   // GL_ARB_multisample
   glSampleCoverageARB: procedure(Value: GLclampf; invert: GLboolean); stdcall;
   glSamplePassARB: procedure(pass: GLEnum); stdcall;

   // GL_ARB_texture_compression
   glCompressedTexImage3DARB: procedure(target: GLEnum; level: GLint; internalformat: GLEnum; Width, Height, depth: GLsizei; border: GLint; imageSize: GLsizei; data: pointer); stdcall;
   glCompressedTexImage2DARB: procedure(target: GLEnum; level: GLint; internalformat: GLEnum; Width, Height: GLsizei; border: GLint; imageSize: GLsizei; data: pointer); stdcall;
   glCompressedTexImage1DARB: procedure(target: GLEnum; level: GLint; internalformat: GLEnum; Width: GLsizei; border: GLint; imageSize: GLsizei; data: pointer); stdcall;
   glCompressedTexSubImage3DARB: procedure(target: GLEnum; level: GLint; xoffset, yoffset, zoffset: GLint; width, height, depth: GLsizei; Format: GLEnum; imageSize: GLsizei; data: pointer); stdcall;
   glCompressedTexSubImage2DARB: procedure(target: GLEnum; level: GLint; xoffset, yoffset: GLint; width, height: GLsizei; Format: GLEnum; imageSize: GLsizei; data: pointer); stdcall;
   glCompressedTexSubImage1DARB: procedure(target: GLEnum; level: GLint; xoffset: GLint; width: GLsizei; Format: GLEnum; imageSize: GLsizei; data: pointer); stdcall;
   glGetCompressedTexImageARB: procedure(target: GLEnum; level: GLint; img: pointer); stdcall;

   // GL_ARB_vertex_program
   glVertexAttrib1sARB: procedure(index: GLuint; x: GLshort); stdcall;
   glVertexAttrib1fARB: procedure(index: GLuint; x: GLfloat); stdcall;
   glVertexAttrib1dARB: procedure(index: GLuint; x: GLdouble); stdcall;
   glVertexAttrib2sARB: procedure(index: GLuint; x: GLshort; y: GLshort); stdcall;
   glVertexAttrib2fARB: procedure(index: GLuint; x: GLfloat; y: GLfloat); stdcall;
   glVertexAttrib2dARB: procedure(index: GLuint; x: GLdouble; y: GLdouble); stdcall;
   glVertexAttrib3sARB: procedure(index: GLuint; x: GLshort; y: GLshort; z: GLshort); stdcall;
   glVertexAttrib3fARB: procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat); stdcall;
   glVertexAttrib3dARB: procedure(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble); stdcall;
   glVertexAttrib4sARB: procedure(index: GLuint; x: GLshort; y: GLshort; z: GLshort; w: GLshort); stdcall;
   glVertexAttrib4fARB: procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); stdcall;
   glVertexAttrib4dARB: procedure(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); stdcall;
   glVertexAttrib4NubARB: procedure(index: GLuint; x: GLubyte; y: GLubyte; z: GLubyte; w: GLubyte); stdcall;
   glVertexAttrib1svARB: procedure(index: GLuint; const v: PGLshort); stdcall;
   glVertexAttrib1fvARB: procedure(index: GLuint; const v: PGLfloat); stdcall;
   glVertexAttrib1dvARB: procedure(index: GLuint; const v: PGLdouble); stdcall;
   glVertexAttrib2svARB: procedure(index: GLuint; const v: PGLshort); stdcall;
   glVertexAttrib2fvARB: procedure(index: GLuint; const v: PGLfloat); stdcall;
   glVertexAttrib2dvARB: procedure(index: GLuint; const v: PGLdouble); stdcall;
   glVertexAttrib3svARB: procedure(index: GLuint; const v: PGLshort); stdcall;
   glVertexAttrib3fvARB: procedure(index: GLuint; const v: PGLfloat); stdcall;
   glVertexAttrib3dvARB: procedure(index: GLuint; const v: PGLdouble); stdcall;
   glVertexAttrib4bvARB: procedure(index: GLuint; const v: PGLbyte); stdcall;
   glVertexAttrib4svARB: procedure(index: GLuint; const v: PGLshort); stdcall;
   glVertexAttrib4ivARB: procedure(index: GLuint; const v: PGLint); stdcall;
   glVertexAttrib4ubvARB: procedure(index: GLuint; const v: PGLubyte); stdcall;
   glVertexAttrib4usvARB: procedure(index: GLuint; const v: PGLushort); stdcall;
   glVertexAttrib4uivARB: procedure(index: GLuint; const v: PGLuint); stdcall;
   glVertexAttrib4fvARB: procedure(index: GLuint; const v: PGLfloat); stdcall;
   glVertexAttrib4dvARB: procedure(index: GLuint; const v: PGLdouble); stdcall;
   glVertexAttrib4NbvARB: procedure(index: GLuint; const v: PGLbyte); stdcall;
   glVertexAttrib4NsvARB: procedure(index: GLuint; const v: PGLshort); stdcall;
   glVertexAttrib4NivARB: procedure(index: GLuint; const v: PGLint); stdcall;
   glVertexAttrib4NubvARB: procedure(index: GLuint; const v: PGLubyte); stdcall;
   glVertexAttrib4NusvARB: procedure(index: GLuint; const v: PGLushort); stdcall;
   glVertexAttrib4NuivARB: procedure(index: GLuint; const v: PGLuint); stdcall;
   glVertexAttribPointerARB: procedure(index: GLuint; size: GLint; _type: GLenum; normalized: GLboolean; stride: GLsizei; const _pointer: pointer); stdcall;
   glEnableVertexAttribArrayARB: procedure(index: GLuint); stdcall;
   glDisableVertexAttribArrayARB: procedure(index: GLuint); stdcall;
   glProgramStringARB: procedure(target: GLenum; format: GLenum; len: GLsizei; const _string: pointer); stdcall;
   glBindProgramARB: procedure(target: GLenum; _program: GLuint); stdcall;
   glDeleteProgramsARB: procedure(n: GLsizei; const programs: PGLuint); stdcall;
   glGenProgramsARB: procedure(n: GLsizei; programs: PGLuint); stdcall;
   glProgramEnvParameter4dARB: procedure(target: GLenum; index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); stdcall;
   glProgramEnvParameter4dvARB: procedure(target: GLenum; index: GLuint; const params: PGLdouble); stdcall;
   glProgramEnvParameter4fARB: procedure(target: GLenum; index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); stdcall;
   glProgramEnvParameter4fvARB: procedure(target: GLenum; index: GLuint; const params: PGLfloat); stdcall;
   glProgramLocalParameter4dARB: procedure(target: GLenum; index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); stdcall;
   glProgramLocalParameter4dvARB: procedure(target: GLenum; index: GLuint; const params: PGLdouble); stdcall;
   glProgramLocalParameter4fARB: procedure(target: GLenum; index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); stdcall;
   glProgramLocalParameter4fvARB: procedure(target: GLenum; index: GLuint; const params: PGLfloat); stdcall;
   glGetProgramEnvParameterdvARB: procedure(target: GLenum; index: GLuint; params: PGLdouble); stdcall;
   glGetProgramEnvParameterfvARB: procedure(target: GLenum; index: GLuint; params: PGLfloat); stdcall;
   glGetProgramLocalParameterdvARB: procedure(target: GLenum; index: GLuint; params: PGLdouble); stdcall;
   glGetProgramLocalParameterfvARB: procedure(target: GLenum; index: GLuint; params: PGLfloat); stdcall;
   glGetProgramivARB: procedure(target: GLenum; pname: GLenum; params: PGLint); stdcall;
   glGetProgramStringARB: procedure(target: GLenum; pname: GLenum; _string: pointer); stdcall;
   glGetVertexAttribdvARB: procedure(index: GLuint; pname: GLenum; params: PGLdouble); stdcall;
   glGetVertexAttribfvARB: procedure(index: GLuint; pname: GLenum; params: PGLfloat); stdcall;
   glGetVertexAttribivARB: procedure(index: GLuint; pname: GLenum; params: PGLint); stdcall;
   glGetVertexAttribPointervARB: procedure(index: GLuint; pname: GLenum; _pointer: pointer); stdcall;
   glIsProgramARB: function(_program: GLuint): GLboolean; stdcall;

   // GL_ARB_vertex_buffer_object
   glBindBufferARB: procedure(target: GLenum; buffer: GLuint); stdcall;
   glDeleteBuffersARB: procedure(n: GLsizei; const buffers: PGLuint); stdcall;
   glGenBuffersARB: procedure(n: GLsizei; buffers: PGLuint); stdcall;
   glIsBufferARB: function(buffer: GLuint): GLboolean; stdcall;
   glBufferDataARB: procedure(target: GLenum; size: GLsizei; const data: Pointer; usage: GLenum); stdcall;
   glBufferSubDataARB: procedure(target: GLenum; offset: GLuint; size: GLsizei; const data: Pointer); stdcall;
   glGetBufferSubDataARB: procedure(target: GLenum; offset: GLuint; size: GLsizei; data: Pointer); stdcall;
   glMapBufferARB: function(target: GLenum; access: GLenum): Pointer; stdcall;
   glUnmapBufferARB: function(target: GLenum): GLboolean; stdcall;
   glGetBufferParameterivARB: procedure(target: GLenum; pname: GLenum; params: PGLint); stdcall;
   glGetBufferPointervARB: procedure(target: GLenum; pname: GLenum; params: Pointer); stdcall;

   // GL_EXT_blend_color
   glBlendColorEXT: procedure(red, green, blue: GLclampf; alpha: GLclampf); stdcall;

   // GL_EXT_texture3D
   glTexImage3DEXT: procedure(target: GLEnum; level: GLint; internalformat: GLEnum; width, height, depth: GLsizei; border: GLint; Format, AType: GLEnum; pixels: Pointer); stdcall;

   // GL_SGIS_multisample
   glSampleMaskSGIS: procedure(Value: GLclampf; invert: GLboolean); stdcall;
   glSamplePatternSGIS: procedure(pattern: GLEnum); stdcall;

   // GL_EXT_blend_minmax
   glBlendEquationEXT: procedure(mode: GLEnum); stdcall;

   // GL_EXT_paletted_texture
   glGetColorTableParameterivEXT: procedure(target, pname: GLEnum; params: PGLint); stdcall;
   glGetColorTableParameterfvEXT: procedure(target, pname: GLEnum; params: PGLfloat); stdcall;

   // GL_EXT_draw_range_elements
   glDrawRangeElementsEXT: procedure(mode: GLEnum; start, Aend: GLuint; Count: GLsizei; Atype: GLEnum; indices: Pointer); stdcall;

   // GL_EXT_secondary_color
   glSecondaryColor3bEXT: procedure(red, green, blue: GLbyte); stdcall;
   glSecondaryColor3bvEXT: procedure(v: PGLbyte); stdcall;
   glSecondaryColor3dEXT: procedure(red, green, blue: GLdouble); stdcall;
   glSecondaryColor3dvEXT: procedure(v: PGLdouble); stdcall;
   glSecondaryColor3fEXT: procedure(red, green, blue: GLfloat); stdcall;
   glSecondaryColor3fvEXT: procedure(v: PGLfloat); stdcall;
   glSecondaryColor3iEXT: procedure(red, green, blue: GLint); stdcall;
   glSecondaryColor3ivEXT: procedure(v: PGLint); stdcall;

   glSecondaryColor3sEXT: procedure(red, green, blue: GLshort); stdcall;
   glSecondaryColor3svEXT: procedure(v: PGLshort); stdcall;
   glSecondaryColor3ubEXT: procedure(red, green, blue: GLubyte); stdcall;
   glSecondaryColor3ubvEXT: procedure(v: PGLubyte); stdcall;
   glSecondaryColor3uiEXT: procedure(red, green, blue: GLuint); stdcall;
   glSecondaryColor3uivEXT: procedure(v: PGLuint); stdcall;
   glSecondaryColor3usEXT: procedure(red, green, blue: GLushort); stdcall;
   glSecondaryColor3usvEXT: procedure(v: PGLushort); stdcall;
   glSecondaryColorPointerEXT: procedure(Size: GLint; Atype: GLEnum; stride: GLsizei; p: pointer); stdcall;

   // GL_EXT_texture_perturb_normal
   glTextureNormalEXT: procedure(mode: GLEnum); stdcall;

   // GL_EXT_multi_draw_arrays
   glMultiDrawArraysEXT: procedure(mode: GLEnum; First: PGLint; Count: PGLsizei; primcount: GLsizei); stdcall;
   glMultiDrawElementsEXT: procedure(mode: GLEnum; Count: PGLsizei; AType: GLEnum; var indices; primcount: GLsizei); stdcall;

   // GL_EXT_fog_coord
   glFogCoordfEXT: procedure(coord: GLfloat); stdcall;
   glFogCoordfvEXT: procedure(coord: PGLfloat); stdcall;
   glFogCoorddEXT: procedure(coord: GLdouble); stdcall;
   glFogCoorddvEXT: procedure(coord: PGLdouble); stdcall;
   glFogCoordPointerEXT: procedure(AType: GLEnum; stride: GLsizei; p: Pointer); stdcall;

   // GL_EXT_blend_func_separate
   glBlendFuncSeparateEXT: procedure(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha: GLEnum); stdcall;

   // GL_EXT_vertex_weighting
   glVertexWeightfEXT: procedure(weight: GLfloat); stdcall;
   glVertexWeightfvEXT: procedure(weight: PGLfloat); stdcall;
   glVertexWeightPointerEXT: procedure(Size: GLsizei; Atype: GLEnum; stride: GLsizei; p: pointer); stdcall;

   // GL_NV_vertex_array_range
   glFlushVertexArrayRangeNV: procedure; stdcall;
   glVertexArrayRangeNV: procedure(Size: GLsizei; p: pointer); stdcall;
   wglAllocateMemoryNV: function(size: GLsizei; readFrequency, writeFrequency, priority: Single): Pointer; stdcall;
   wglFreeMemoryNV: procedure(ptr: Pointer); stdcall;

   // GL_NV_register_combiners
   glCombinerParameterfvNV: procedure(pname: GLEnum; params: PGLfloat); stdcall;
   glCombinerParameterfNV: procedure(pname: GLEnum; param: GLfloat); stdcall;
   glCombinerParameterivNV: procedure(pname: GLEnum; params: PGLint); stdcall;
   glCombinerParameteriNV: procedure(pname: GLEnum; param: GLint); stdcall;
   glCombinerInputNV: procedure(stage, portion, variable, input, mapping, componentUsage: GLEnum); stdcall;
   glCombinerOutputNV: procedure(stage, portion, abOutput, cdOutput, sumOutput, scale, bias: GLEnum; abDotProduct, cdDotProduct, muxSum: GLboolean); stdcall;
   glFinalCombinerInputNV: procedure(variable, input, mapping, componentUsage: GLEnum); stdcall;
   glGetCombinerInputParameterfvNV: procedure(stage, portion, variable, pname: GLEnum; params: PGLfloat); stdcall;
   glGetCombinerInputParameterivNV: procedure(stage, portion, variable, pname: GLEnum; params: PGLint); stdcall;
   glGetCombinerOutputParameterfvNV: procedure(stage, portion, pname: GLEnum; params: PGLfloat); stdcall;
   glGetCombinerOutputParameterivNV: procedure(stage, portion, pname: GLEnum; params: PGLint); stdcall;
   glGetFinalCombinerInputParameterfvNV: procedure(variable, pname: GLEnum; params: PGLfloat); stdcall;
   glGetFinalCombinerInputParameterivNV: procedure(variable, pname: GLEnum; params: PGLint); stdcall;

   // GL_NV_fence
   glGenFencesNV: procedure(n: GLsizei; fences: PGLuint); stdcall;
   glDeleteFencesNV: procedure(n: GLsizei; fences: PGLuint); stdcall;
   glSetFenceNV: procedure(fence: GLuint; condition: GLEnum); stdcall;
   glTestFenceNV: function(fence: GLuint): GLboolean; stdcall;
   glFinishFenceNV: procedure(fence: GLuint); stdcall;
   glIsFenceNV: function(fence: GLuint): GLboolean; stdcall;
   glGetFenceivNV: procedure(fence: GLuint; pname: GLEnum; params: PGLint); stdcall;

   // GL_NV_occlusion_query
   glGenOcclusionQueriesNV: procedure(n: GLsizei; ids: PGLuint); stdcall;
   glDeleteOcclusionQueriesNV: procedure(n: GLsizei; const ids: PGLuint); stdcall;
   glIsOcclusionQueryNV: function(id: GLuint): GLboolean; stdcall;
   glBeginOcclusionQueryNV: procedure(id: GLuint); stdcall;
   glEndOcclusionQueryNV: procedure; stdcall;
   glGetOcclusionQueryivNV: procedure(id: GLuint; pname: GLEnum; params: PGLint); stdcall;
   glGetOcclusionQueryuivNV: procedure(id: GLuint; pname: GLEnum; params: PGLuint); stdcall;

   // GL_MESA_resize_buffers
   glResizeBuffersMESA: procedure; stdcall;

   // GL_3DFX_tbuffer
   glTbufferMask3DFX: procedure(mask: GLuint); stdcall;

   // GL_EXT_multisample
   glSampleMaskEXT: procedure(Value: GLclampf; invert: GLboolean); stdcall;
   glSamplePatternEXT: procedure(pattern: GLEnum); stdcall;

   // GL_SGIS_texture_color_mask
   glTextureColorMaskSGIS: procedure(red, green, blue, alpha: GLboolean); stdcall;

   // GL_NV_vertex_program
   glAreProgramsResidentNV: procedure(n: GLsizei; programs: PGLuint; residences: PGLboolean); stdcall;
   glBindProgramNV: procedure(target: GLEnum; id: GLuint); stdcall;
   glDeleteProgramsNV: procedure(n: GLsizei; programs: PGLuint); stdcall;
   glExecuteProgramNV: procedure(target: GLEnum; id: GLuint; params: PGLfloat); stdcall;
   glGenProgramsNV: procedure(n: GLsizei; programs: PGLuint); stdcall;
   glGetProgramParameterdvNV: procedure (target: GLEnum; index: GLuint; pname: GLEnum; params: PGLdouble); stdcall;
   glGetProgramParameterfvNV: procedure (target: GLEnum; index: GLuint; pname: GLEnum; params: PGLfloat); stdcall;
   glGetProgramivNV: procedure (id: GLuint; pname: GLEnum; params: PGLint); stdcall;
   glGetProgramStringNV: procedure (id: GLuint; pname: GLEnum; programIdx: PGLubyte); stdcall;
   glGetTrackMatrixivNV: procedure (target: GLEnum; address: GLuint; pname: GLEnum; params: PGLint); stdcall;
   glGetVertexAttribdvNV: procedure (index: GLuint; pname: GLEnum; params: PGLdouble); stdcall;
   glGetVertexAttribfvNV: procedure (index: GLuint; pname: GLEnum; params: PGLfloat); stdcall;
   glGetVertexAttribivNV: procedure (index: GLuint; pname: GLEnum; params: PGLint); stdcall;
   glGetVertexAttribPointervNV: procedure (index: GLuint; pname: GLEnum; pointer: PPointer); stdcall;
   glIsProgramNV: function (id: GLuint): GLboolean; stdcall;
   glLoadProgramNV: procedure (target: GLEnum; id: GLuint; len: GLsizei; programIdx: PGLubyte); stdcall;
   glProgramParameter4dNV: procedure (target: GLEnum; index: GLuint; x, y, z, w: GLdouble); stdcall;
   glProgramParameter4dvNV: procedure (target: GLEnum; index: GLuint; v: PGLdouble ); stdcall;
   glProgramParameter4fNV: procedure (target: GLEnum; index: GLuint; x, y, z, w: GLfloat); stdcall;
   glProgramParameter4fvNV: procedure (target: GLEnum; index: GLuint; v: PGLfloat); stdcall;
   glProgramParameters4dvNV: procedure (target: GLEnum; index: GLuint; count: GLsizei; v: PGLdouble); stdcall;
   glProgramParameters4fvNV: procedure (target: GLEnum; index: GLuint; count: GLsizei; v: PGLfloat); stdcall;
   glRequestResidentProgramsNV: procedure (n: GLsizei; programs: PGLuint); stdcall;
   glTrackMatrixNV: procedure (target: GLEnum; address: GLuint; matrix: GLEnum; transform: GLEnum); stdcall;
   glVertexAttribPointerNV: procedure (index: GLuint; fsize: GLint; vertextype: GLEnum; stride: GLsizei; pointer: Pointer); stdcall;
   glVertexAttrib1dNV: procedure (index: GLuint; x: GLdouble); stdcall;
   glVertexAttrib1dvNV: procedure (index: GLuint; v: PGLdouble); stdcall;
   glVertexAttrib1fNV: procedure (index: GLuint; x: GLfloat); stdcall;
   glVertexAttrib1fvNV: procedure (index: GLuint; v: PGLfloat); stdcall;
   glVertexAttrib1sNV: procedure (index: GLuint; x: GLshort); stdcall;
   glVertexAttrib1svNV: procedure (index: GLuint; v: PGLshort); stdcall;
   glVertexAttrib2dNV: procedure (index: GLuint; x: GLdouble; y: GLdouble); stdcall;
   glVertexAttrib2dvNV: procedure (index: GLuint; v: PGLdouble); stdcall;
   glVertexAttrib2fNV: procedure (index: GLuint; x: GLfloat; y: GLfloat); stdcall;
   glVertexAttrib2fvNV: procedure (index: GLuint; v: PGLfloat); stdcall;
   glVertexAttrib2sNV: procedure (index: GLuint; x: GLshort; y: GLshort); stdcall;
   glVertexAttrib2svNV: procedure (index: GLuint; v: PGLshort); stdcall;
   glVertexAttrib3dNV: procedure (index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble); stdcall;
   glVertexAttrib3dvNV: procedure (index: GLuint; v: PGLdouble); stdcall;
   glVertexAttrib3fNV: procedure (index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat); stdcall;
   glVertexAttrib3fvNV: procedure (index: GLuint; v: PGLfloat); stdcall;
   glVertexAttrib3sNV: procedure (index: GLuint; x: GLshort; y: GLshort; z: GLshort); stdcall;
   glVertexAttrib3svNV: procedure (index: GLuint; v: PGLshort); stdcall;
   glVertexAttrib4dNV: procedure (index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); stdcall;
   glVertexAttrib4dvNV: procedure (index: GLuint; v: PGLdouble); stdcall;
   glVertexAttrib4fNV: procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); stdcall;
   glVertexAttrib4fvNV: procedure(index: GLuint; v: PGLfloat); stdcall;
   glVertexAttrib4sNV: procedure (index: GLuint; x: GLshort; y: GLshort; z: GLdouble; w: GLshort); stdcall;
   glVertexAttrib4svNV: procedure (index: GLuint; v: PGLshort); stdcall;
   glVertexAttrib4ubvNV: procedure (index: GLuint; v: PGLubyte); stdcall;
   glVertexAttribs1dvNV: procedure (index: GLuint; count: GLsizei; v: PGLdouble); stdcall;
   glVertexAttribs1fvNV: procedure (index: GLuint; count: GLsizei; v: PGLfloat); stdcall;
   glVertexAttribs1svNV: procedure (index: GLuint; count: GLsizei; v: PGLshort); stdcall;
   glVertexAttribs2dvNV: procedure (index: GLuint; count: GLsizei; v: PGLdouble); stdcall;
   glVertexAttribs2fvNV: procedure (index: GLuint; count: GLsizei; v: PGLfloat); stdcall;
   glVertexAttribs2svNV: procedure (index: GLuint; count: GLsizei; v: PGLshort); stdcall;
   glVertexAttribs3dvNV: procedure (index: GLuint; count: GLsizei; v: PGLdouble); stdcall;
   glVertexAttribs3fvNV: procedure (index: GLuint; count: GLsizei; v: PGLfloat); stdcall;
   glVertexAttribs3svNV: procedure (index: GLuint; count: GLsizei; v: PGLshort); stdcall;
   glVertexAttribs4dvNV: procedure (index: GLuint; count: GLsizei; v: PGLdouble); stdcall;
   glVertexAttribs4fvNV: procedure (index: GLuint; count: GLsizei; v: PGLfloat); stdcall;
   glVertexAttribs4svNV: procedure (index: GLuint; count: GLsizei; v: PGLshort); stdcall;
   glVertexAttribs4ubvNV: procedure (index: GLuint; count: GLsizei; v: PGLubyte); stdcall;

{$ifdef LINUX}
type
   GLXContext    = Pointer;
   GLXPixmap     = XID;
   GLXDrawable   = XID;

   // GLX 1.3 and later
   GLXFBConfig   = Pointer;
   GLXFBConfigID = XID;
   GLXContextID  = XID;
   GLXWindow     = XID;
   GLXPbuffer    = XID;

var
   glXChooseVisual: function(dpy: PDisplay; screen: GLint; attribList: PGLint): PXVisualInfo; cdecl;
   glXCreateContext: function(dpy: PDisplay; vis: PXVisualInfo; shareList: GLXContext; direct: GLboolean): GLXContext; cdecl;
   glXDestroyContext: procedure(dpy: PDisplay; ctx: GLXContext); cdecl;
   glXMakeCurrent: function(dpy: PDisplay; drawable: GLXDrawable; ctx: GLXContext): GLboolean; cdecl;
   glXCopyContext: procedure(dpy: PDisplay; src: GLXContext; dst: GLXContext; mask: GLuint); cdecl;
   glXSwapBuffers: procedure(dpy: PDisplay; drawable: GLXDrawable); cdecl;
   glXCreateGLXPixmap: function(dpy: PDisplay; visual: PXVisualInfo; pixmap: Pixmap): GLXPixmap; cdecl;
   glXDestroyGLXPixmap: procedure(dpy: PDisplay; pixmap: GLXPixmap); cdecl;
   glXQueryExtension: function(dpy: PDisplay; errorb: PGLInt; event: PGLInt): GLboolean; cdecl;
   glXQueryVersion: function(dpy: PDisplay; maj: PGLInt; min: PGLINT): GLboolean; cdecl;
   glXIsDirect: function(dpy: PDisplay; ctx: GLXContext): GLboolean; cdecl;
   glXGetConfig: function(dpy: PDisplay; visual: PXVisualInfo; attrib: GLint; value: PGLInt): GLint; cdecl;
   glXGetCurrentContext: function: GLXContext; cdecl;
   glXGetCurrentDrawable: function: GLXDrawable; cdecl;
   glXWaitGL: procedure; cdecl;
   glXWaitX: procedure; cdecl;
   glXUseXFont: procedure(font: Font; first: GLint; count: GLint; list: GLint); cdecl;

   // GLX 1.1 and later
   glXQueryExtensionsString: function(dpy: PDisplay; screen: GLint): PChar; cdecl;
   glXQueryServerString: function(dpy: PDisplay; screen: GLint; name: GLint): PChar; cdecl;
   glXGetClientString: function(dpy: PDisplay; name: GLint): PChar; cdecl;

   // GLX 1.2 and later
   glXGetCurrentDisplay: function: PDisplay; cdecl;

   // GLX 1.3 and later
   glXChooseFBConfig: function(dpy: PDisplay; screen: GLint; attribList: PGLInt; nitems: PGLInt): GLXFBConfig; cdecl;
   glXGetFBConfigAttrib: function(dpy: PDisplay; config: GLXFBConfig; attribute: GLint; value: PGLInt): GLint; cdecl;
   glXGetFBConfigs: function(dpy: PDisplay; screen: GLint; nelements: PGLInt): GLXFBConfig; cdecl;
   glXGetVisualFromFBConfig: function(dpy: PDisplay; config: GLXFBConfig): PXVisualInfo; cdecl;
   glXCreateWindow: function(dpy: PDisplay; config: GLXFBConfig; win: Window; const attribList: PGLInt): GLXWindow; cdecl;
   glXDestroyWindow: procedure(dpy: PDisplay; window: GLXWindow); cdecl;
   glXCreatePixmap: function(dpy: PDisplay; config: GLXFBConfig; pixmap: Pixmap; attribList: PGLInt): GLXPixmap; cdecl;
   glXDestroyPixmap: procedure(dpy: PDisplay; pixmap: GLXPixmap); cdecl;
   glXCreatePbuffer: function(dpy: PDisplay; config: GLXFBConfig; attribList: PGLInt): GLXPBuffer; cdecl;
   glXDestroyPbuffer: procedure(dpy: PDisplay; pbuf: GLXPBuffer); cdecl;
   glXQueryDrawable: procedure(dpy: PDisplay; draw: GLXDrawable; attribute: GLint; value: PGLuint); cdecl;
   glXCreateNewContext: function(dpy: PDisplay; config: GLXFBConfig; renderType: GLint; shareList: GLXContext; direct: GLboolean): GLXContext; cdecl;
   glXMakeContextCurrent: function(dpy: PDisplay; draw: GLXDrawable; read: GLXDrawable; ctx: GLXContext): GLboolean; cdecl;
   glXGetCurrentReadDrawable: function: GLXDrawable; cdecl;
   glXQueryContext: function(dpy: PDisplay; ctx: GLXContext; attribute: GLint; value: PGLInt): GLint; cdecl;
   glXSelectEvent: procedure(dpy: PDisplay; drawable: GLXDrawable; mask: GLsizei); cdecl;
   glXGetSelectedEvent: procedure(dpy: PDisplay; drawable: GLXDrawable; mask: GLsizei); cdecl;
   glXGetVideoSyncSGI: function(count: PGLuint): GLint; cdecl;
   glXWaitVideoSyncSGI: function(divisor: GLint; remainder: GLint; count: PGLuint): GLint; cdecl;
   glXFreeContextEXT: procedure(dpy: PDisplay; context: GLXContext); cdecl;
   glXGetContextIDEXT: function(const context: GLXContext): GLXContextID; cdecl;
   glXGetCurrentDisplayEXT: function: PDisplay; cdecl;
   glXImportContextEXT: function(dpy: PDisplay; contextID: GLXContextID): GLXContext; cdecl;
   glXQueryContextInfoEXT: function(dpy: PDisplay; context: GLXContext; attribute: GLint; value: PGLInt): GLint; cdecl;
   glXCopySubBufferMESA: procedure(dpy: PDisplay; drawable: GLXDrawable; x: GLint; y: GLint; width: GLint; height: GLint); cdecl;
   glXCreateGLXPixmapMESA: function(dpy: PDisplay; visual: PXVisualInfo; pixmap: Pixmap; cmap: Colormap): GLXPixmap; cdecl;
   glXReleaseBuffersMESA: function(dpy: PDisplay; d: GLXDrawable): GLboolean; cdecl;
   glXSet3DfxModeMESA: function(mode: GLint): GLboolean; cdecl;
{$endif}

//------------------------------------------------------------------------------

{$ifdef MSWINDOWS}
procedure ReadExtensions;
procedure ReadWGLExtensions;
procedure ReadImplementationProperties;
procedure ReadWGLImplementationProperties;
{$endif}

// ------------------------------------------------------------------
// ------------------------------------------------------------------
// ------------------------------------------------------------------
implementation
// ------------------------------------------------------------------
// ------------------------------------------------------------------
// ------------------------------------------------------------------


{$ifdef MSWINDOWS}
const
   INVALID_MODULEHANDLE = 0;
{$endif}

{$ifdef LINUX}
const
   INVALID_MODULEHANDLE = nil;

var
   GLHandle: Pointer;
   GLUHandle: Pointer;
{$endif}

resourcestring
{$ifdef MSWINDOWS}
  SDefaultGLLibrary= 'OpenGL32.dll';
  SDefaultGLULibrary= 'GLU32.dll';
{$endif}

{$ifdef LINUX}
  SDefaultGLLibrary= 'libGL.so'; 
  SDefaultGLULibrary= 'libGLU.so'; 
{$endif}

// ReadExtensions
//
procedure ReadExtensions;
   // To be used in an active rendering context only!
begin
   // Extensions integrated into 1.2 core

   // GL 1.2
   glDrawRangeElements := wglGetProcAddress('glDrawRangeElements');
   glTexImage3D := wglGetProcAddress('glTexImage3D');

   // GL 1.2 ARB imaging
   glBlendColor := wglGetProcAddress('glBlendColor');
   glBlendEquation := wglGetProcAddress('glBlendEquation');
   glColorSubTable := wglGetProcAddress('glColorSubTable'); 
   glCopyColorSubTable := wglGetProcAddress('glCopyColorSubTable');
   glColorTable := wglGetProcAddress('glCopyColorSubTable');
   glCopyColorTable := wglGetProcAddress('glCopyColorTable'); 
   glColorTableParameteriv := wglGetProcAddress('glColorTableParameteriv'); 
   glColorTableParameterfv := wglGetProcAddress('glColorTableParameterfv');
   glGetColorTable := wglGetProcAddress('glGetColorTable'); 
   glGetColorTableParameteriv := wglGetProcAddress('glGetColorTableParameteriv');
   glGetColorTableParameterfv := wglGetProcAddress('glGetColorTableParameterfv');
   glConvolutionFilter1D := wglGetProcAddress('glConvolutionFilter1D'); 
   glConvolutionFilter2D := wglGetProcAddress('glConvolutionFilter2D'); 
   glCopyConvolutionFilter1D := wglGetProcAddress('glCopyConvolutionFilter1D');
   glCopyConvolutionFilter2D := wglGetProcAddress('glCopyConvolutionFilter2D');
   glGetConvolutionFilter := wglGetProcAddress('glGetConvolutionFilter'); 
   glSeparableFilter2D := wglGetProcAddress('glSeparableFilter2D'); 
   glGetSeparableFilter := wglGetProcAddress('glGetSeparableFilter'); 
   glConvolutionParameteri := wglGetProcAddress('glConvolutionParameteri'); 
   glConvolutionParameteriv := wglGetProcAddress('glConvolutionParameteriv');
   glConvolutionParameterf := wglGetProcAddress('glConvolutionParameterf'); 
   glConvolutionParameterfv := wglGetProcAddress('glConvolutionParameterfv');
   glGetConvolutionParameteriv := wglGetProcAddress('glGetConvolutionParameteriv'); 
   glGetConvolutionParameterfv := wglGetProcAddress('glGetConvolutionParameterfv'); 
   glHistogram := wglGetProcAddress('glHistogram');
   glResetHistogram := wglGetProcAddress('glResetHistogram');
   glGetHistogram := wglGetProcAddress('glGetHistogram');
   glGetHistogramParameteriv := wglGetProcAddress('glGetHistogramParameteriv'); 
   glGetHistogramParameterfv := wglGetProcAddress('glGetHistogramParameterfv'); 
   glMinmax := wglGetProcAddress('glMinmax'); 
   glResetMinmax := wglGetProcAddress('glResetMinmax'); 
   glGetMinmax := wglGetProcAddress('glGetMinmax');
   glGetMinmaxParameteriv := wglGetProcAddress('glGetMinmaxParameteriv');
   glGetMinmaxParameterfv := wglGetProcAddress('glGetMinmaxParameterfv');

   {$ifdef LINUX}
   glXChooseVisual := GetProcAddress(GLHandle, 'glXChooseVisual');
   glXCreateContext := GetProcAddress(GLHandle, 'glXCreateContext');
   glXDestroyContext := GetProcAddress(GLHandle, 'glXDestroyContext'); 
   glXMakeCurrent := GetProcAddress(GLHandle, 'glXMakeCurrent'); 
   glXCopyContext := GetProcAddress(GLHandle, 'glXCopyContext'); 
   glXSwapBuffers := GetProcAddress(GLHandle, 'glXSwapBuffers'); 
   glXCreateGLXPixmap := GetProcAddress(GLHandle, 'glXCreateGLXPixmap');
   glXDestroyGLXPixmap := GetProcAddress(GLHandle, 'glXDestroyGLXPixmap'); 
   glXQueryExtension := GetProcAddress(GLHandle, 'glXQueryExtension'); 
   glXQueryVersion := GetProcAddress(GLHandle, 'glXQueryVersion');
   glXIsDirect := GetProcAddress(GLHandle, 'glXIsDirect');
   glXGetConfig := GetProcAddress(GLHandle, 'glXGetConfig'); 
   glXGetCurrentContext := GetProcAddress(GLHandle, 'glXGetCurrentContext');
   glXGetCurrentDrawable := GetProcAddress(GLHandle, 'glXGetCurrentDrawable'); 
   glXWaitGL := GetProcAddress(GLHandle, 'glXWaitGL'); 
   glXWaitX := GetProcAddress(GLHandle, 'glXWaitX'); 
   glXUseXFont := GetProcAddress(GLHandle, 'glXUseXFont');
   glXQueryExtensionsString := GetProcAddress(GLHandle, 'glXQueryExtensionsString'); 
   glXQueryServerString := GetProcAddress(GLHandle, 'glXQueryServerString'); 
   glXGetClientString := GetProcAddress(GLHandle, 'glXGetClientString');
   glXGetCurrentDisplay := GetProcAddress(GLHandle, 'glXGetCurrentDisplay'); 
   glXChooseFBConfig := GetProcAddress(GLHandle, 'glXChooseFBConfig');
   glXGetFBConfigAttrib := GetProcAddress(GLHandle, 'glXGetFBConfigAttrib');
   glXGetFBConfigs := GetProcAddress(GLHandle, 'glXGetFBConfigs');
   glXGetVisualFromFBConfig := GetProcAddress(GLHandle, 'glXGetVisualFromFBConfig'); 
   glXCreateWindow := GetProcAddress(GLHandle, 'glXCreateWindow'); 
   glXDestroyWindow := GetProcAddress(GLHandle, 'glXDestroyWindow'); 
   glXCreatePixmap := GetProcAddress(GLHandle, 'glXCreatePixmap');
   glXDestroyPixmap := GetProcAddress(GLHandle, 'glXDestroyPixmap'); 
   glXCreatePbuffer := GetProcAddress(GLHandle, 'glXCreatePbuffer'); 
   glXDestroyPbuffer := GetProcAddress(GLHandle, 'glXDestroyPbuffer');
   glXQueryDrawable := GetProcAddress(GLHandle, 'glXQueryDrawable'); 
   glXCreateNewContext := GetProcAddress(GLHandle, 'glXCreateNewContext'); 
   glXMakeContextCurrent := GetProcAddress(GLHandle, 'glXMakeContextCurrent'); 
   glXGetCurrentReadDrawable := GetProcAddress(GLHandle, 'glXGetCurrentReadDrawable');
   glXQueryContext := GetProcAddress(GLHandle, 'glXQueryContext'); 
   glXSelectEvent := GetProcAddress(GLHandle, 'glXSelectEvent'); 
   glXGetSelectedEvent := GetProcAddress(GLHandle, 'glXGetSelectedEvent');
   glXGetVideoSyncSGI := GetProcAddress(GLHandle, 'glXGetVideoSyncSGI'); 
   glXWaitVideoSyncSGI := GetProcAddress(GLHandle, 'glXWaitVideoSyncSGI'); 
   glXFreeContextEXT := GetProcAddress(GLHandle, 'glXFreeContextEXT'); 
   glXGetContextIDEXT := GetProcAddress(GLHandle, 'glXGetContextIDEXT'); 
   glXGetCurrentDisplayEXT := GetProcAddress(GLHandle, 'glXGetCurrentDisplayEXT');
   glXImportContextEXT := GetProcAddress(GLHandle, 'glXImportContextEXT');
   glXQueryContextInfoEXT := GetProcAddress(GLHandle, 'glXQueryContextInfoEXT');
   glXCopySubBufferMESA := GetProcAddress(GLHandle, 'glXCopySubBufferMESA');
   glXCreateGLXPixmapMESA := GetProcAddress(GLHandle, 'glXCreateGLXPixmapMESA');
   glXReleaseBuffersMESA := GetProcAddress(GLHandle, 'glXReleaseBuffersMESA');
   glXSet3DfxModeMESA := GetProcAddress(GLHandle, 'glXSet3DfxModeMESA');
   {$endif}

   // GL extensions
   glArrayElementArrayEXT := wglGetProcAddress('glArrayElementArrayEXT');
   glColorTableEXT := wglGetProcAddress('glColorTableEXT');
   glColorSubTableEXT := wglGetProcAddress('glColorSubTableEXT');
   glGetColorTableEXT := wglGetProcAddress('glGetColorTableEXT');
   glGetColorTablePameterivEXT := wglGetProcAddress('glGetColorTablePameterivEXT');
   glGetColorTablePameterfvEXT := wglGetProcAddress('glGetColorTablePameterfvEXT');
   glCopyTexImage1DEXT := wglGetProcAddress('glCopyTexImage1DEXT');
   glCopyTexSubImage1DEXT := wglGetProcAddress('glCopyTexSubImage1DEXT');
   glCopyTexImage2DEXT := wglGetProcAddress('glCopyTexImage2DEXT');
   glCopyTexSubImage2DEXT := wglGetProcAddress('glCopyTexSubImage2DEXT');
   glCopyTexSubImage3DEXT := wglGetProcAddress('glCopyTexSubImage3DEXT');
   glIndexFuncEXT := wglGetProcAddress('glIndexFuncEXT');
   glIndexMaterialEXT := wglGetProcAddress('glIndexMaterialEXT');
   glPolygonOffsetEXT := wglGetProcAddress('glPolygonOffsetEXT');
   glTexSubImage1dEXT := wglGetProcAddress('glTexSubImage1DEXT');
   glTexSubImage2dEXT := wglGetProcAddress('glTexSubImage2DEXT');
   glTexSubImage3dEXT := wglGetProcAddress('glTexSubImage3DEXT');
   glGenTexturesEXT := wglGetProcAddress('glGenTexturesEXT');
   glDeleteTexturesEXT := wglGetProcAddress('glDeleteTexturesEXT');
   glBindTextureEXT := wglGetProcAddress('glBindTextureEXT');
   glPrioritizeTexturesEXT := wglGetProcAddress('glPrioritizeTexturesEXT');
   glAreTexturesResidentEXT := wglGetProcAddress('glAreTexturesResidentEXT');
   glIsTextureEXT := wglGetProcAddress('glIsTextureEXT');

   // EXT_compiled_vertex_array
   glLockArraysEXT := wglGetProcAddress('glLockArraysEXT');
   glUnlockArraysEXT := wglGetProcAddress('glUnlockArraysEXT');

   // EXT_vertex_array
   glArrayElementEXT := wglGetProcAddress('glArrayElementEXT');
   glColorPointerEXT := wglGetProcAddress('glColorPointerEXT');
   glDrawArraysEXT := wglGetProcAddress('glDrawArraysEXT');
   glEdgeFlagPointerEXT := wglGetProcAddress('glEdgeFlagPointerEXT'); 
   glGetPointervEXT := wglGetProcAddress('glGetPointervEXT'); 
   glIndexPointerEXT := wglGetProcAddress('glIndexPointerEXT');
   glNormalPointerEXT := wglGetProcAddress('glNormalPointerEXT');
   glTexCoordPointerEXT := wglGetProcAddress('glTexCoordPointerEXT'); 
   glVertexPointerEXT := wglGetProcAddress('glVertexPointerEXT'); 

   // ARB_multitexture
   glMultiTexCoord1dARB := wglGetProcAddress('glMultiTexCoord1dARB'); 
   glMultiTexCoord1dVARB := wglGetProcAddress('glMultiTexCoord1dVARB');
   glMultiTexCoord1fARBP := wglGetProcAddress('glMultiTexCoord1fARBP'); 
   glMultiTexCoord1fVARB := wglGetProcAddress('glMultiTexCoord1fVARB'); 
   glMultiTexCoord1iARB := wglGetProcAddress('glMultiTexCoord1iARB'); 
   glMultiTexCoord1iVARB := wglGetProcAddress('glMultiTexCoord1iVARB'); 
   glMultiTexCoord1sARBP := wglGetProcAddress('glMultiTexCoord1sARBP'); 
   glMultiTexCoord1sVARB := wglGetProcAddress('glMultiTexCoord1sVARB'); 
   glMultiTexCoord2dARB := wglGetProcAddress('glMultiTexCoord2dARB');
   glMultiTexCoord2dvARB := wglGetProcAddress('glMultiTexCoord2dvARB'); 
   glMultiTexCoord2fARB := wglGetProcAddress('glMultiTexCoord2fARB');
   glMultiTexCoord2fvARB := wglGetProcAddress('glMultiTexCoord2fvARB');
   glMultiTexCoord2iARB := wglGetProcAddress('glMultiTexCoord2iARB');
   glMultiTexCoord2ivARB := wglGetProcAddress('glMultiTexCoord2ivARB');
   glMultiTexCoord2sARB := wglGetProcAddress('glMultiTexCoord2sARB'); 
   glMultiTexCoord2svARB := wglGetProcAddress('glMultiTexCoord2svARB'); 
   glMultiTexCoord3dARB := wglGetProcAddress('glMultiTexCoord3dARB'); 
   glMultiTexCoord3dvARB := wglGetProcAddress('glMultiTexCoord3dvARB'); 
   glMultiTexCoord3fARB := wglGetProcAddress('glMultiTexCoord3fARB'); 
   glMultiTexCoord3fvARB := wglGetProcAddress('glMultiTexCoord3fvARB'); 
   glMultiTexCoord3iARB := wglGetProcAddress('glMultiTexCoord3iARB'); 
   glMultiTexCoord3ivARB := wglGetProcAddress('glMultiTexCoord3ivARB'); 
   glMultiTexCoord3sARB := wglGetProcAddress('glMultiTexCoord3sARB'); 
   glMultiTexCoord3svARB := wglGetProcAddress('glMultiTexCoord3svARB'); 
   glMultiTexCoord4dARB := wglGetProcAddress('glMultiTexCoord4dARB'); 
   glMultiTexCoord4dvARB := wglGetProcAddress('glMultiTexCoord4dvARB'); 
   glMultiTexCoord4fARB := wglGetProcAddress('glMultiTexCoord4fARB');
   glMultiTexCoord4fvARB := wglGetProcAddress('glMultiTexCoord4fvARB'); 
   glMultiTexCoord4iARB := wglGetProcAddress('glMultiTexCoord4iARB');
   glMultiTexCoord4ivARB := wglGetProcAddress('glMultiTexCoord4ivARB');
   glMultiTexCoord4sARB := wglGetProcAddress('glMultiTexCoord4sARB');
   glMultiTexCoord4svARB := wglGetProcAddress('glMultiTexCoord4svARB'); 
   glActiveTextureARB := wglGetProcAddress('glActiveTextureARB');
   glClientActiveTextureARB := wglGetProcAddress('glClientActiveTextureARB');

   // EXT_stencil_two_side
   glActiveStencilFaceEXT := wglGetProcAddress('glActiveStencilFaceEXT');

   // WIN_swap_hint
   glAddSwapHintRectWIN := wglGetProcAddress('glAddSwapHintRectWIN'); 

   // GL_ARB_point_parameter
   glPointParameterfARB := wglGetProcAddress('glPointParameterfARB');
   glPointParameterfvARB := wglGetProcAddress('glPointParameterfvARB');

   // GL_ARB_transpose_matrix
   glLoadTransposeMatrixfARB := wglGetProcAddress('glLoadTransposeMatrixfARB');
   glLoadTransposeMatrixdARB := wglGetProcAddress('glLoadTransposeMatrixdARB'); 
   glMultTransposeMatrixfARB := wglGetProcAddress('glMultTransposeMatrixfARB'); 
   glMultTransposeMatrixdARB := wglGetProcAddress('glMultTransposeMatrixdARB'); 

   glSampleCoverageARB := wglGetProcAddress('glSampleCoverageARB');
   glSamplePassARB := wglGetProcAddress('glSamplePassARB'); 

   // GL_ARB_multisample
   glCompressedTexImage3DARB := wglGetProcAddress('glCompressedTexImage3DARB');
   glCompressedTexImage2DARB := wglGetProcAddress('glCompressedTexImage2DARB');
   glCompressedTexImage1DARB := wglGetProcAddress('glCompressedTexImage1DARB');
   glCompressedTexSubImage3DARB := wglGetProcAddress('glCompressedTexSubImage3DARB');
   glCompressedTexSubImage2DARB := wglGetProcAddress('glCompressedTexSubImage2DARB');
   glCompressedTexSubImage1DARB := wglGetProcAddress('glCompressedTexSubImage1DARB');
   glGetCompressedTexImageARB := wglGetProcAddress('glGetCompressedTexImageARB');

   // GL_ARB_vertex_program
   glVertexAttrib1sARB := wglGetProcAddress('glVertexAttrib1sARB');
   glVertexAttrib1fARB := wglGetProcAddress('glVertexAttrib1fARB');
   glVertexAttrib1dARB := wglGetProcAddress('glVertexAttrib1dARB');
   glVertexAttrib2sARB := wglGetProcAddress('glVertexAttrib2sARB');
   glVertexAttrib2fARB := wglGetProcAddress('glVertexAttrib2fARB');
   glVertexAttrib2dARB := wglGetProcAddress('glVertexAttrib2dARB');
   glVertexAttrib3sARB := wglGetProcAddress('glVertexAttrib3sARB');
   glVertexAttrib3fARB := wglGetProcAddress('glVertexAttrib3fARB');
   glVertexAttrib3dARB := wglGetProcAddress('glVertexAttrib3dARB');
   glVertexAttrib4sARB := wglGetProcAddress('glVertexAttrib4sARB');
   glVertexAttrib4fARB := wglGetProcAddress('glVertexAttrib4fARB');
   glVertexAttrib4dARB := wglGetProcAddress('glVertexAttrib4dARB');
   glVertexAttrib4NubARB := wglGetProcAddress('glVertexAttrib4NubARB');
   glVertexAttrib1svARB := wglGetProcAddress('glVertexAttrib1svARB');
   glVertexAttrib1fvARB := wglGetProcAddress('glVertexAttrib1fvARB');
   glVertexAttrib1dvARB := wglGetProcAddress('glVertexAttrib1dvARB');
   glVertexAttrib2svARB := wglGetProcAddress('glVertexAttrib2svARB');
   glVertexAttrib2fvARB := wglGetProcAddress('glVertexAttrib2fvARB');
   glVertexAttrib2dvARB := wglGetProcAddress('glVertexAttrib2dvARB');
   glVertexAttrib3svARB := wglGetProcAddress('glVertexAttrib3svARB');
   glVertexAttrib3fvARB := wglGetProcAddress('glVertexAttrib3fvARB');
   glVertexAttrib3dvARB := wglGetProcAddress('glVertexAttrib3dvARB');
   glVertexAttrib4bvARB := wglGetProcAddress('glVertexAttrib4bvARB');
   glVertexAttrib4svARB := wglGetProcAddress('glVertexAttrib4svARB');
   glVertexAttrib4ivARB := wglGetProcAddress('glVertexAttrib4ivARB');
   glVertexAttrib4ubvARB := wglGetProcAddress('glVertexAttrib4ubvARB');
   glVertexAttrib4usvARB := wglGetProcAddress('glVertexAttrib4usvARB');
   glVertexAttrib4uivARB := wglGetProcAddress('glVertexAttrib4uivARB');
   glVertexAttrib4fvARB := wglGetProcAddress('glVertexAttrib4fvARB');
   glVertexAttrib4dvARB := wglGetProcAddress('glVertexAttrib4dvARB');
   glVertexAttrib4NbvARB := wglGetProcAddress('glVertexAttrib4NbvARB');
   glVertexAttrib4NsvARB := wglGetProcAddress('glVertexAttrib4NsvARB');
   glVertexAttrib4NivARB := wglGetProcAddress('glVertexAttrib4NivARB');
   glVertexAttrib4NubvARB := wglGetProcAddress('glVertexAttrib4NubvARB');
   glVertexAttrib4NusvARB := wglGetProcAddress('glVertexAttrib4NusvARB');
   glVertexAttrib4NuivARB := wglGetProcAddress('glVertexAttrib4NuivARB');
   glVertexAttribPointerARB := wglGetProcAddress('glVertexAttribPointerARB');
   glEnableVertexAttribArrayARB := wglGetProcAddress('glEnableVertexAttribArrayARB');
   glDisableVertexAttribArrayARB := wglGetProcAddress('glDisableVertexAttribArrayARB');
   glProgramStringARB := wglGetProcAddress('glProgramStringARB');
   glBindProgramARB := wglGetProcAddress('glBindProgramARB');
   glDeleteProgramsARB := wglGetProcAddress('glDeleteProgramsARB');
   glGenProgramsARB := wglGetProcAddress('glGenProgramsARB');
   glProgramEnvParameter4dARB := wglGetProcAddress('glProgramEnvParameter4dARB');
   glProgramEnvParameter4dvARB := wglGetProcAddress('glProgramEnvParameter4dvARB');
   glProgramEnvParameter4fARB := wglGetProcAddress('glProgramEnvParameter4fARB');
   glProgramEnvParameter4fvARB := wglGetProcAddress('glProgramEnvParameter4fvARB');
   glProgramLocalParameter4dARB := wglGetProcAddress('glProgramLocalParameter4dARB');
   glProgramLocalParameter4dvARB := wglGetProcAddress('glProgramLocalParameter4dvARB');
   glProgramLocalParameter4fARB := wglGetProcAddress('glProgramLocalParameter4fARB');
   glProgramLocalParameter4fvARB := wglGetProcAddress('glProgramLocalParameter4fvARB');
   glGetProgramEnvParameterdvARB := wglGetProcAddress('glGetProgramEnvParameterdvARB');
   glGetProgramEnvParameterfvARB := wglGetProcAddress('glGetProgramEnvParameterfvARB');
   glGetProgramLocalParameterdvARB := wglGetProcAddress('glGetProgramLocalParameterdvARB');
   glGetProgramLocalParameterfvARB := wglGetProcAddress('glGetProgramLocalParameterfvARB');
   glGetProgramivARB := wglGetProcAddress('glGetProgramivARB');
   glGetProgramStringARB := wglGetProcAddress('glGetProgramStringARB');
   glGetVertexAttribdvARB := wglGetProcAddress('glGetVertexAttribdvARB');
   glGetVertexAttribfvARB := wglGetProcAddress('glGetVertexAttribfvARB');
   glGetVertexAttribivARB := wglGetProcAddress('glGetVertexAttribivARB');
   glGetVertexAttribPointervARB := wglGetProcAddress('glGetVertexAttribPointervARB');
   glIsProgramARB := wglGetProcAddress('glIsProgramARB');

   // GL_ARB_vertex_buffer_object
   glBindBufferARB := wglGetProcAddress('glBindBufferARB');
   glDeleteBuffersARB := wglGetProcAddress('glDeleteBuffersARB');
   glGenBuffersARB := wglGetProcAddress('glGenBuffersARB');
   glIsBufferARB := wglGetProcAddress('glIsBufferARB');
   glBufferDataARB := wglGetProcAddress('glBufferDataARB');
   glBufferSubDataARB := wglGetProcAddress('glBufferSubDataARB');
   glGetBufferSubDataARB := wglGetProcAddress('glGetBufferSubDataARB');
   glMapBufferARB := wglGetProcAddress('glMapBufferARB');
   glUnmapBufferARB := wglGetProcAddress('glUnmapBufferARB');
   glGetBufferParameterivARB := wglGetProcAddress('glGetBufferParameterivARB');
   glGetBufferPointervARB := wglGetProcAddress('glGetBufferPointervARB');

   // GL_EXT_blend_color
   glBlendColorEXT := wglGetProcAddress('glBlendColorEXT');

   // GL_EXT_texture3D
   glTexImage3DEXT := wglGetProcAddress('glTexImage3DEXT');

   // GL_SGIS_multisample
   glSampleMaskSGIS := wglGetProcAddress('glSampleMaskSGIS'); 
   glSamplePatternSGIS := wglGetProcAddress('glSamplePatternSGIS'); 

   // GL_EXT_blend_minmax
   glBlendEquationEXT := wglGetProcAddress('glBlendEquationEXT'); 

   // GL_EXT_paletted_texture
   glGetColorTableParameterivEXT := wglGetProcAddress('glGetColorTableParameterivEXT'); 
   glGetColorTableParameterfvEXT := wglGetProcAddress('glGetColorTableParameterfvEXT');

   // GL_EXT_draw_range_elements
   glDrawRangeElementsEXT := wglGetProcAddress('glDrawRangeElementsEXT');

   // GL_EXT_secondary_color
   glSecondaryColor3bEXT := wglGetProcAddress('glSecondaryColor3bEXT');
   glSecondaryColor3bvEXT := wglGetProcAddress('glSecondaryColor3bvEXT');
   glSecondaryColor3dEXT := wglGetProcAddress('glSecondaryColor3dEXT'); 
   glSecondaryColor3dvEXT := wglGetProcAddress('glSecondaryColor3dvEXT'); 
   glSecondaryColor3fEXT := wglGetProcAddress('glSecondaryColor3fEXT'); 
   glSecondaryColor3fvEXT := wglGetProcAddress('glSecondaryColor3fvEXT'); 
   glSecondaryColor3iEXT := wglGetProcAddress('glSecondaryColor3iEXT'); 
   glSecondaryColor3ivEXT := wglGetProcAddress('glSecondaryColor3ivEXT'); 
   glSecondaryColor3sEXT := wglGetProcAddress('glSecondaryColor3sEXT'); 
   glSecondaryColor3svEXT := wglGetProcAddress('glSecondaryColor3svEXT'); 
   glSecondaryColor3ubEXT := wglGetProcAddress('glSecondaryColor3ubEXT'); 
   glSecondaryColor3ubvEXT := wglGetProcAddress('glSecondaryColor3ubvEXT'); 
   glSecondaryColor3uiEXT := wglGetProcAddress('glSecondaryColor3uiEXT'); 
   glSecondaryColor3uivEXT := wglGetProcAddress('glSecondaryColor3uivEXT'); 
   glSecondaryColor3usEXT := wglGetProcAddress('glSecondaryColor3usEXT');
   glSecondaryColor3usvEXT := wglGetProcAddress('glSecondaryColor3usvEXT');
   glSecondaryColorPointerEXT := wglGetProcAddress('glSecondaryColorPointerEXT'); 

   // GL_EXT_texture_perturb_normal
   glTextureNormalEXT := wglGetProcAddress('glTextureNormalEXT'); 

   // GL_EXT_multi_draw_arrays
   glMultiDrawArraysEXT := wglGetProcAddress('glMultiDrawArraysEXT'); 
   glMultiDrawElementsEXT := wglGetProcAddress('glMultiDrawElementsEXT'); 

   // GL_EXT_fog_coord
   glFogCoordfEXT := wglGetProcAddress('glFogCoordfEXT'); 
   glFogCoordfvEXT := wglGetProcAddress('glFogCoordfvEXT'); 
   glFogCoorddEXT := wglGetProcAddress('glFogCoorddEXT'); 
   glFogCoorddvEXT := wglGetProcAddress('glFogCoorddvEXT'); 
   glFogCoordPointerEXT := wglGetProcAddress('glFogCoordPointerEXT'); 

   // GL_EXT_blend_func_separate
   glBlendFuncSeparateEXT := wglGetProcAddress('glBlendFuncSeparateEXT');

   // GL_EXT_vertex_weighting
   glVertexWeightfEXT := wglGetProcAddress('glVertexWeightfEXT');
   glVertexWeightfvEXT := wglGetProcAddress('glVertexWeightfvEXT'); 
   glVertexWeightPointerEXT := wglGetProcAddress('glVertexWeightPointerEXT'); 

   // GL_NV_vertex_array_range
   glFlushVertexArrayRangeNV := wglGetProcAddress('glFlushVertexArrayRangeNV'); 
   glVertexArrayRangeNV := wglGetProcAddress('glVertexArrayRangeNV'); 
   wglAllocateMemoryNV := wglGetProcAddress('wglAllocateMemoryNV'); 
   wglFreeMemoryNV := wglGetProcaddress('wglFreeMemoryNV'); 

   // GL_NV_register_combiners
   glCombinerParameterfvNV := wglGetProcAddress('glCombinerParameterfvNV'); 
   glCombinerParameterfNV := wglGetProcAddress('glCombinerParameterfNV');
   glCombinerParameterivNV := wglGetProcAddress('glCombinerParameterivNV'); 
   glCombinerParameteriNV := wglGetProcAddress('glCombinerParameteriNV'); 
   glCombinerInputNV := wglGetProcAddress('glCombinerInputNV');
   glCombinerOutputNV := wglGetProcAddress('glCombinerOutputNV'); 
   glFinalCombinerInputNV := wglGetProcAddress('glFinalCombinerInputNV'); 
   glGetCombinerInputParameterfvNV := wglGetProcAddress('glGetCombinerInputParameterfvNV');
   glGetCombinerInputParameterivNV := wglGetProcAddress('glGetCombinerInputParameterivNV'); 
   glGetCombinerOutputParameterfvNV := wglGetProcAddress('glGetCombinerOutputParameterfvNV');
   glGetCombinerOutputParameterivNV := wglGetProcAddress('glGetCombinerOutputParameterivNV');
   glGetFinalCombinerInputParameterfvNV := wglGetProcAddress('glGetFinalCombinerInputParameterfvNV'); 
   glGetFinalCombinerInputParameterivNV := wglGetProcAddress('glGetFinalCombinerInputParameterivNV');

   // GL_NV_fence
   glGenFencesNV := wglGetProcAddress('glGenFencesNV');
   glDeleteFencesNV := wglGetProcAddress('glDeleteFencesNV');
   glSetFenceNV := wglGetProcAddress('glSetFenceNV');
   glTestFenceNV := wglGetProcAddress('glTestFenceNV');
   glFinishFenceNV := wglGetProcAddress('glFinishFenceNV');
   glIsFenceNV := wglGetProcAddress('glIsFenceNV');
   glGetFenceivNV := wglGetProcAddress('glGetFenceivNV');

   // GL_NV_occlusion_query
   glGenOcclusionQueriesNV := wglGetProcAddress('glGenOcclusionQueriesNV');
   glDeleteOcclusionQueriesNV := wglGetProcAddress('glDeleteOcclusionQueriesNV');
   glIsOcclusionQueryNV := wglGetProcAddress('glIsOcclusionQueryNV');
   glBeginOcclusionQueryNV := wglGetProcAddress('glBeginOcclusionQueryNV');
   glEndOcclusionQueryNV := wglGetProcAddress('glEndOcclusionQueryNV');
   glGetOcclusionQueryivNV := wglGetProcAddress('glGetOcclusionQueryivNV');
   glGetOcclusionQueryuivNV := wglGetProcAddress('glGetOcclusionQueryuivNV');

   // GL_MESA_resize_buffers
   glResizeBuffersMESA := wglGetProcAddress('glResizeBuffersMESA');

   // GL_3DFX_tbuffer
   glTbufferMask3DFX := wglGetProcAddress('glTbufferMask3DFX');

   // GL_EXT_multisample
   glSampleMaskEXT := wglGetProcAddress('glSampleMaskEXT');
   glSamplePatternEXT := wglGetProcAddress('glSamplePatternEXT');

   // GL_SGIS_texture_color_mask
   glTextureColorMaskSGIS := wglGetProcAddress('glTextureColorMaskSGIS');

   // GLU extensions
   gluNurbsCallbackDataEXT := wglGetProcAddress('gluNurbsCallbackDataEXT');
   gluNewNurbsTessellatorEXT := wglGetProcAddress('gluNewNurbsTessellatorEXT'); 
   gluDeleteNurbsTessellatorEXT := wglGetProcAddress('gluDeleteNurbsTessellatorEXT');

   // GL_NV_vertex_program
   glAreProgramsResidentNV := wglGetProcAddress('glAreProgramsResidentNV'); 
   glBindProgramNV := wglGetProcAddress('glBindProgramNV');
   glDeleteProgramsNV := wglGetProcAddress('glDeleteProgramsNV'); 
   glExecuteProgramNV := wglGetProcAddress('glExecuteProgramNV'); 
   glGenProgramsNV := wglGetProcAddress('glGenProgramsNV');
   glGetProgramParameterdvNV := wglGetProcAddress('glGetProgramParameterdvNV'); 
   glGetProgramParameterfvNV := wglGetProcAddress('glGetProgramParameterfvNV');
   glGetProgramivNV := wglGetProcAddress('glGetProgramivNV');
   glGetProgramStringNV := wglGetProcAddress('glGetProgramStringNV'); 
   glGetTrackMatrixivNV := wglGetProcAddress('glGetTrackMatrixivNV'); 
   glGetVertexAttribdvNV:= wglGetProcAddress('glGetVertexAttribdvNV'); 
   glGetVertexAttribfvNV:= wglGetProcAddress('glGetVertexAttribfvNV'); 
   glGetVertexAttribivNV:= wglGetProcAddress('glGetVertexAttribivNV');
   glGetVertexAttribPointervNV := wglGetProcAddress ('glGetVertexAttribPointervNV');
   glIsProgramNV := wglGetProcAddress('glIsProgramNV'); 
   glLoadProgramNV := wglGetProcAddress('glLoadProgramNV'); 
   glProgramParameter4dNV := wglGetProcAddress('glProgramParameter4dNV'); 
   glProgramParameter4dvNV := wglGetProcAddress('glProgramParameter4dvNV'); 
   glProgramParameter4fNV := wglGetProcAddress('glProgramParameter4fNV'); 
   glProgramParameter4fvNV := wglGetProcAddress('glProgramParameter4fvNV');
   glProgramParameters4dvNV := wglGetProcAddress ('glProgramParameters4dvNV'); 
   glProgramParameters4fvNV := wglGetProcAddress ('glProgramParameters4fvNV');
   glRequestResidentProgramsNV := wglGetProcAddress ('glRequestResidentProgramsNV');
   glTrackMatrixNV := wglGetProcAddress('glTrackMatrixNV'); 
   glVertexAttribPointerNV := wglGetProcAddress('glVertexAttribPointerNV');
   glVertexAttrib1dNV := wglGetProcAddress('glVertexAttrib1dNV'); 
   glVertexAttrib1dvNV := wglGetProcAddress('glVertexAttrib1dvNV'); 
   glVertexAttrib1fNV := wglGetProcAddress('glVertexAttrib1fNV');
   glVertexAttrib1fvNV := wglGetProcAddress('glVertexAttrib1fvNV'); 
   glVertexAttrib1sNV := wglGetProcAddress('glVertexAttrib1sNV'); 
   glVertexAttrib1svNV := wglGetProcAddress('glVertexAttrib1svNV'); 
   glVertexAttrib2dNV := wglGetProcAddress('glVertexAttrib2dNV');
   glVertexAttrib2dvNV := wglGetProcAddress('glVertexAttrib2dvNV'); 
   glVertexAttrib2fNV := wglGetProcAddress('glVertexAttrib2fNV'); 
   glVertexAttrib2fvNV := wglGetProcAddress('glVertexAttrib2fvNV'); 
   glVertexAttrib2sNV := wglGetProcAddress('glVertexAttrib2sNV'); 
   glVertexAttrib2svNV := wglGetProcAddress('glVertexAttrib2svNV'); 
   glVertexAttrib3dNV := wglGetProcAddress('glVertexAttrib3dNV'); 
   glVertexAttrib3dvNV := wglGetProcAddress('glVertexAttrib3dvNV');
   glVertexAttrib3fNV := wglGetProcAddress('glVertexAttrib3fNV'); 
   glVertexAttrib3fvNV := wglGetProcAddress('glVertexAttrib3fvNV');
   glVertexAttrib3sNV := wglGetProcAddress('glVertexAttrib3sNV');
   glVertexAttrib3svNV := wglGetProcAddress('glVertexAttrib3svNV');
   glVertexAttrib4dNV := wglGetProcAddress('glVertexAttrib4dNV');
   glVertexAttrib4dvNV := wglGetProcAddress('glVertexAttrib4dvNV'); 
   glVertexAttrib4fNV := wglGetProcAddress('glVertexAttrib4fNV');
   glVertexAttrib4fvNV := wglGetProcAddress('glVertexAttrib4fvNV'); 
   glVertexAttrib4sNV := wglGetProcAddress('glVertexAttrib4sNV'); 
   glVertexAttrib4svNV := wglGetProcAddress('glVertexAttrib4svNV'); 
   glVertexAttrib4ubvNV := wglGetProcAddress('glVertexAttrib4ubvNV'); 
   glVertexAttribs1dvNV := wglGetProcAddress('glVertexAttribs1dvNV'); 
   glVertexAttribs1fvNV := wglGetProcAddress('glVertexAttribs1fvNV'); 
   glVertexAttribs1svNV := wglGetProcAddress('glVertexAttribs1svNV'); 
   glVertexAttribs2dvNV := wglGetProcAddress('glVertexAttribs2dvNV'); 
   glVertexAttribs2fvNV := wglGetProcAddress('glVertexAttribs2fvNV'); 
   glVertexAttribs2svNV := wglGetProcAddress('glVertexAttribs2svNV');
   glVertexAttribs3dvNV := wglGetProcAddress('glVertexAttribs3dvNV');
   glVertexAttribs3fvNV := wglGetProcAddress('glVertexAttribs3fvNV');
   glVertexAttribs3svNV := wglGetProcAddress('glVertexAttribs3svNV');
   glVertexAttribs4dvNV := wglGetProcAddress('glVertexAttribs4dvNV'); 
   glVertexAttribs4fvNV := wglGetProcAddress('glVertexAttribs4fvNV'); 
   glVertexAttribs4svNV := wglGetProcAddress('glVertexAttribs4svNV'); 
   glVertexAttribs4ubvNV := wglGetProcAddress('glVertexAttribs4ubvN');

   ReadWGLExtensions;
end;

// ReadWGLExtensions
//
procedure ReadWGLExtensions;
begin
   // ARB wgl extensions
   wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
   wglGetPixelFormatAttribivARB := wglGetProcAddress('wglGetPixelFormatAttribivARB');
   wglGetPixelFormatAttribfvARB := wglGetProcAddress('wglGetPixelFormatAttribfvARB');
   wglChoosePixelFormatARB := wglGetProcAddress('wglChoosePixelFormatARB');

   wglCreatePbufferARB := wglGetProcAddress('wglCreatePbufferARB');
   wglGetPbufferDCARB := wglGetProcAddress('wglGetPbufferDCARB');
   wglReleasePbufferDCARB := wglGetProcAddress('wglReleasePbufferDCARB');
   wglDestroyPbufferARB := wglGetProcAddress('wglDestroyPbufferARB');
   wglQueryPbufferARB := wglGetProcAddress('wglQueryPbufferARB');

   wglCreateBufferRegionARB := wglGetProcAddress('wglCreateBufferRegionARB');
   wglDeleteBufferRegionARB := wglGetProcAddress('wglDeleteBufferRegionARB');
   wglSaveBufferRegionARB := wglGetProcAddress('wglSaveBufferRegionARB');
   wglRestoreBufferRegionARB := wglGetProcAddress('wglRestoreBufferRegionARB');

   // -EGG- ----------------------------
   wglSwapIntervalEXT := wglGetProcAddress('wglSwapIntervalEXT');
   wglGetSwapIntervalEXT := wglGetProcAddress('wglGetSwapIntervalEXT');
end;

// TrimAndSplitVersionString
//
procedure TrimAndSplitVersionString(Buffer: String; var Max, Min: Integer);
// Peels out the X.Y form from the given Buffer which must contain a version string like "text Minor.Major.Build text"
// at least however "Major.Minor".
var
  Separator: Integer;
begin
    Min := 0;
    Max := 0;

    Separator := Pos('.', Buffer);

    if (Separator > 1) and (Separator < Length(Buffer)) and (Buffer[Separator - 1] in ['0'..'9']) and
      (Buffer[Separator + 1] in ['0'..'9']) then
    begin
      // OK, it's a valid version string. Now remove unnecessary parts.
      Dec(Separator);
      // Find last non-numeric character before version number.
      while (Separator > 0) and (Buffer[Separator] in ['0'..'9']) do
        Dec(Separator);
      // Delete leading characters which do not belong to the version string.
      Delete(Buffer, 1, Separator);
      Separator := Pos('.', Buffer) + 1;
      // Find first non-numeric character after version number
      while (Separator <= Length(Buffer)) and (Buffer[Separator] in ['0'..'9']) do
        Inc(Separator);
      Delete(Buffer, Separator, 255);
      Separator := Pos('.', Buffer); // This is necessary because the buffer length might have changed.
      Max := StrToInt(Copy(Buffer, 1, Separator - 1));
      Min := StrToInt(Copy(Buffer, Separator + 1, 255));
     end;
end;

// ReadImplementationProperties
//
procedure ReadImplementationProperties;
var
   Buffer : String;
   MajorVersion, MinorVersion: Integer;

   // Checks if the given Extension string is in Buffer.
   function CheckExtension(const Extension: string): Boolean;
   var
     ExtPos: Integer;
   begin
     // First find the position of the extension string as substring in Buffer.
     ExtPos := Pos(Extension, Buffer);
     Result := ExtPos > 0;
     // Now check that it isn't only a substring of another extension.
     if Result then
       Result := ((ExtPos + Length(Extension) - 1)= Length(Buffer))
                 or (Buffer[ExtPos + Length(Extension)]=' ');
   end;

begin
   // determine version of implementation
   // GL
   buffer:=glGetString(GL_VERSION);
   TrimAndSplitVersionString(buffer, majorversion, minorVersion);
   GL_VERSION_1_0:=True;
   GL_VERSION_1_1:=(minorVersion>=1);
   GL_VERSION_1_2:=(minorVersion>=2);
   GL_VERSION_1_3:=(minorVersion>=3);
   GL_VERSION_1_4:=(minorVersion>=4);
   GL_VERSION_1_5:=(minorVersion>=5);

   // GLU
   buffer:=gluGetString(GLU_VERSION);
   TrimAndSplitVersionString(buffer, majorversion, minorVersion);
   GLU_VERSION_1_1:=True; // won't load without at least GLU 1.1
   GLU_VERSION_1_2:=(minorVersion>1);
   GLU_VERSION_1_3:=(minorVersion>2);

   // check supported extensions
   // GL
   Buffer := StrPas(glGetString(GL_EXTENSIONS));

   GL_3DFX_multisample := CheckExtension('GL_3DFX_multisample');
   GL_3DFX_tbuffer := CheckExtension('GL_3DFX_tbuffer');
   GL_3DFX_texture_compression_FXT1 := CheckExtension('GL_3DFX_texture_compression_FXT1');

   GL_ARB_imaging := CheckExtension('GL_ARB_imaging');
   GL_ARB_multisample := CheckExtension(' GL_ARB_multisample'); // ' ' to avoid collision with WGL variant
   GL_ARB_multitexture := CheckExtension('GL_ARB_multitexture');
   GL_ARB_depth_texture := CheckExtension('GL_ARB_depth_texture');
   GL_ARB_shadow := CheckExtension('GL_ARB_shadow');
   GL_ARB_texture_border_clamp := CheckExtension('GL_ARB_texture_border_clamp');
   GL_ARB_texture_compression := CheckExtension('GL_ARB_texture_compression');
   GL_ARB_texture_cube_map := CheckExtension('GL_ARB_texture_cube_map');
   GL_ARB_transpose_matrix := CheckExtension('GL_ARB_transpose_matrix');
   GL_ARB_vertex_blend := CheckExtension('GL_ARB_vertex_blend');
   GL_ARB_point_parameters := CheckExtension('GL_ARB_point_parameters');
   GL_ARB_texture_env_combine := CheckExtension('GL_ARB_texture_env_combine');
   GL_ARB_texture_env_crossbar := CheckExtension('GL_ARB_texture_env_crossbar');
   GL_ARB_texture_env_dot3 := CheckExtension('GL_ARB_texture_env_dot3');
   GL_ARB_vertex_program := CheckExtension('GL_ARB_vertex_program');
   GL_ARB_vertex_buffer_object := CheckExtension('GL_ARB_vertex_buffer_object');

   GL_EXT_abgr := CheckExtension('GL_EXT_abgr');
   GL_EXT_bgra := CheckExtension('GL_EXT_bgra');
   GL_EXT_blend_color := CheckExtension('GL_EXT_blend_color');
   GL_EXT_blend_func_separate := CheckExtension('GL_EXT_blend_func_separate');
   GL_EXT_blend_logic_op := CheckExtension('GL_EXT_blend_logic_op');
   GL_EXT_blend_minmax := CheckExtension('GL_EXT_blend_minmax');
   GL_EXT_blend_subtract := CheckExtension('GL_EXT_blend_subtract');
   GL_EXT_clip_volume_hint := CheckExtension('GL_EXT_clip_volume_hint');
   GL_EXT_cmyka := CheckExtension('GL_EXT_cmyka');
   GL_EXT_compiled_vertex_array := CheckExtension('GL_EXT_compiled_vertex_array');
   GL_EXT_copy_texture := CheckExtension('GL_EXT_copy_texture');
   GL_EXT_draw_range_elements := CheckExtension('GL_EXT_draw_range_elements');
   GL_EXT_fog_coord := CheckExtension('GL_EXT_fog_coord');
   GL_EXT_light_max_exponent := CheckExtension('GL_EXT_light_max_exponent');
   GL_EXT_misc_attribute := CheckExtension('GL_EXT_misc_attribute');
   GL_EXT_multi_draw_arrays := CheckExtension('GL_EXT_multi_draw_arrays');
   GL_EXT_multisample := CheckExtension('GL_EXT_multisample');
   GL_EXT_packed_pixels := CheckExtension('GL_EXT_packed_pixels');
   GL_EXT_paletted_texture := CheckExtension('GL_EXT_paletted_texture');
   GL_EXT_polygon_offset := CheckExtension('GL_EXT_polygon_offset');
   GL_EXT_rescale_normal := CheckExtension('GL_EXT_rescale_normal');
   GL_EXT_scene_marker := CheckExtension('GL_EXT_scene_marker');
   GL_EXT_secondary_color := CheckExtension('GL_EXT_secondary_color');
   GL_EXT_separate_specular_color := CheckExtension('GL_EXT_separate_specular_color');
   GL_EXT_shared_texture_palette := CheckExtension('GL_EXT_shared_texture_palette');
   GL_EXT_stencil_wrap := CheckExtension('GL_EXT_stencil_wrap');
   GL_EXT_stencil_two_side := CheckExtension('EXT_stencil_two_side');
   GL_EXT_subtexture := CheckExtension('GL_EXT_subtexture');
   GL_EXT_texture_color_table := CheckExtension('GL_EXT_texture_color_table');
   GL_EXT_texture_compression_s3tc := CheckExtension('GL_EXT_texture_compression_s3tc');
   GL_EXT_texture_cube_map := CheckExtension('GL_EXT_texture_cube_map');
   GL_EXT_texture_edge_clamp := CheckExtension('GL_EXT_texture_edge_clamp');
   GL_EXT_texture_env_add := CheckExtension('GL_EXT_texture_env_add');
   GL_EXT_texture_env_combine := CheckExtension('GL_EXT_texture_env_combine');
   GL_EXT_texture_filter_anisotropic := CheckExtension('GL_EXT_texture_filter_anisotropic'); 
   GL_EXT_texture_lod_bias := CheckExtension('GL_EXT_texture_lod_bias'); 
   GL_EXT_texture_object := CheckExtension('GL_EXT_texture_object'); 
   GL_EXT_texture_perturb_normal := CheckExtension('GL_EXT_texture_perturb_normal'); 
   GL_EXT_texture3D := CheckExtension('GL_EXT_texture3D');
   GL_EXT_vertex_array := CheckExtension('GL_EXT_vertex_array');
   GL_EXT_vertex_weighting := CheckExtension('GL_EXT_vertex_weighting');

   GL_HP_occlusion_test := CheckExtension('GL_HP_occlusion_test'); 

   GL_IBM_rasterpos_clip := CheckExtension('GL_IBM_rasterpos_clip');

   GL_KTX_buffer_region := CheckExtension('GL_KTX_buffer_region');

   GL_MESA_resize_buffers := CheckExtension('GL_MESA_resize_buffers'); 

   GL_NV_blend_square := CheckExtension('GL_NV_blend_square'); 
   GL_NV_fog_distance := CheckExtension('GL_NV_fog_distance'); 
   GL_NV_light_max_exponent := CheckExtension('GL_NV_light_max_exponent');
   GL_NV_register_combiners := CheckExtension('GL_NV_register_combiners'); 
   GL_NV_texgen_emboss := CheckExtension('GL_NV_texgen_emboss'); 
   GL_NV_texgen_reflection := CheckExtension('GL_NV_texgen_reflection'); 
   GL_NV_texture_env_combine4 := CheckExtension('GL_NV_texture_env_combine4'); 
   GL_NV_vertex_array_range := CheckExtension('GL_NV_vertex_array_range');
   GL_NV_multisample_filter_hint  := CheckExtension('GL_NV_multisample_filter_hint');
   GL_NV_vertex_program := CheckExtension('GL_NV_vertex_program');
   GL_NV_fence := CheckExtension('GL_NV_fence');
   GL_NV_occlusion_query := CheckExtension('GL_NV_occlusion_query');
   GL_NV_texture_rectangle := CheckExtension('GL_NV_texture_rectangle');

   GL_SGI_color_matrix := CheckExtension('GL_SGI_color_matrix');

   GL_SGIS_generate_mipmap := CheckExtension('GL_SGIS_generate_mipmap');
   GL_SGIS_multisample := CheckExtension('GL_SGIS_multisample');
   GL_SGIS_multitexture := CheckExtension('GL_SGIS_multitexture');
   GL_SGIS_texture_border_clamp := CheckExtension('GL_SGIS_texture_border_clamp');
   GL_SGIS_texture_color_mask := CheckExtension('GL_SGIS_texture_color_mask');
   GL_SGIS_texture_edge_clamp := CheckExtension('GL_SGIS_texture_edge_clamp');
   GL_SGIS_texture_lod := CheckExtension('GL_SGIS_texture_lod'); 

   GL_SGIX_depth_texture := CheckExtension('GL_SGIX_depth_texture');
   GL_SGIX_shadow := CheckExtension('GL_SGIX_shadow'); 
   GL_SGIX_shadow_ambient := CheckExtension('GL_SGIX_shadow_ambient');

   GL_WIN_swap_hint := CheckExtension('GL_WIN_swap_hint');

   WGL_ARB_extensions_string := CheckExtension('WGL_ARB_extensions_string');

   // GLU
   Buffer := gluGetString(GLU_EXTENSIONS);
   GLU_EXT_TEXTURE := CheckExtension('GLU_EXT_TEXTURE');
   GLU_EXT_object_space_tess := CheckExtension('GLU_EXT_object_space_tess');
   GLU_EXT_nurbs_tessellator := CheckExtension('GLU_EXT_nurbs_tessellator');

   ReadWGLImplementationProperties;
end;

{$ifdef MSWINDOWS}

// ReadWGLImplementationProperties
//
procedure ReadWGLImplementationProperties;
var
   buffer: string;

   // Checks if the given Extension string is in Buffer.
   function CheckExtension(const extension : String) : Boolean;
   begin
      Result:=(Pos(extension, Buffer)>0);
   end;

begin
   // ARB wgl extensions
   if Assigned(wglGetExtensionsStringARB) then
      Buffer:=wglGetExtensionsStringARB(wglGetCurrentDC)
   else Buffer:='';
   WGL_ARB_multisample:=CheckExtension('WGL_ARB_multisample');
   WGL_EXT_swap_control:=CheckExtension('WGL_EXT_swap_control');
   WGL_ARB_buffer_region:=CheckExtension('WGL_ARB_buffer_region');
   WGL_ARB_extensions_string:=CheckExtension('WGL_ARB_extensions_string');
   WGL_ARB_pbuffer:=CheckExtension('WGL_ARB_pbuffer ');
   WGL_ARB_pixel_format:=CheckExtension('WGL_ARB_pixel_format');
end;
{$endif}

initialization
 Set8087CW($133F);
finalization
end.
