{------------------------------------------------------------------------------}
{ SibVRV
{ svGE Unit
{ Created 12.03.2001 by Vereshagin Roman Vladimirovich.
{ History:
{  VR - Unit Created
{------------------------------------------------------------------------------}
unit svGE_SoundDriver_WaveOut;
interface

uses svGE_SoundDriverClass,mmsystem,windows,svGE_SoundDataConvetations,messages;

type
   PsvSondDriver_WaveOut = ^TsvSondDriver_WaveOut;
   TsvSondDriver_WaveOut = object(TsvSoundDriver)
     constructor init(bufsize : word);
     destructor  done;virtual;

     function    getcapabilities(var tcap : tcardinfo) : boolean;virtual;
     function    PlayBack_Start(freq,flags : longword) : boolean;virtual;
     procedure   PlayBack_Stop;virtual;
     function    getversionstring : string;virtual;

     function    getnumofoutcontrols : word;virtual;
     function    getoutcontroltype(num : word) : word;virtual;
     function    getoutcontrolname(cnt : word) : string;virtual;
     function    getoutcontrolrange(cnt : word) : longint;virtual;
     function    getoutcontrol(cnt : word) : longint;virtual;
     function    setoutcontrol(cnt : word;val : longint) : boolean;virtual;
     procedure   intrcallproc;virtual;

     function    getbufpointer : pointer;virtual;

     private
     datap             : pointer;
     buffer            : pointer;
     wavehdr           : twavehdr;
     mixthread         : dword;
     mixthreadid       : dword;
     wavefmt           : pwaveformatex;
     waveout           : hwaveout;
     waveoutcaps       : twaveoutcaps;
   end;

implementation

const
  WAVE_FORMAT_EXTENSIBLE            = $FEFF;   { W2k & XP format extension   }

var
  hnd           : hwnd;
  play : record
    callt      : PsvSondDriver_WaveOut;
    sleeptime  : longint;
  end;

const
  versionstring = 'svGE_WND_Waveout';
  buffersize_default = 4096;   { Default playback buffer size - half of the double buffer}

const
  IDC_LABEL1   = 1;

var
  HLabel1 : DWord;



function windowproc(HWND: HWND; uMsg: UINT; wParam: wParam; lParam: lParam): lresult; stdcall;
begin
  windowproc := 0;
  case uMsg of
    WM_CREATE:
      begin
        HLabel1:=CreateWindowEx(0,'STATIC','WaveOut Dummy window',WS_VISIBLE or WS_CHILD,
                                10, 20, 20, 20, hWnd, IDC_LABEL1, hInstance,nil);
      end;
    WM_DESTROY:
      begin
        PostQuitMessage(0);
      end;
  else
    windowproc := DefWindowProc(HWND, uMsg, wParam, lParam);
  end;
end;


var
 done : boolean = false;
// This one is actually not being used at the moment
procedure waveoutproc(hwo: HWAVEOUT; uMsg: UINT; dwInstance,
  dwParam1, dwParam2: DWORD); stdcall;
begin
  case uMsg of
    WOM_OPEN:;
    WOM_CLOSE:  (* fWaveOutHandle := 0*);
    WOM_DONE:  begin
                (* PostMessage(Handle, WM_FINISHED, 0, 0);*)
                // if assigned (play.callt) then play.callt^.intrcallproc;
               end;
  end;
end;





function mixproc(lpParameter : Pointer) : dword;stdcall;
begin
  done := false;
  while not done do
  begin
    sleep(play.sleeptime);
    if assigned (play.callt) then play.callt^.intrcallproc;
  end;
  mixproc := 0;
end;

var
  wc      : TWndClassEx;

constructor TsvSondDriver_WaveOut.init(bufsize : word);
  function checkcaps(freq,bits,channels : longword) : boolean;
  begin
    // set wave format
    fillchar(wavefmt^,sizeof(wavefmt),0);
    with wavefmt^ do
    begin
      wformattag := WAVE_FORMAT_PCM;
      nchannels  := data.outchannels;

      wbitspersample  := bits;

      nsamplespersec  := freq;
      nblockalign     := wbitspersample div 8 * channels;
      navgbytespersec := nsamplespersec * nblockalign;
    end;

    checkcaps := waveoutopen(@waveout,wave_mapper,wavefmt,dword(@waveoutproc),dword(hnd),WAVE_FORMAT_QUERY) = MMSYSERR_NOERROR;
  end;

begin
  inherited init(bufsize);

  getmem(wavefmt,sizeof(wavefmt)+22); // +22 for extensible support

    wc.cbSize        := SizeOf(TWndClassEx);
    wc.Style         := CS_HREDRAW or CS_VREDRAW;
    wc.lpfnWndProc   := @windowproc;
    wc.cbClsExtra    := 0;
    wc.cbWndExtra    := 0;
    wc.hbrBackground := COLOR_APPWORKSPACE;
    wc.lpszMenuName  := nil;
    wc.lpszClassName := versionstring;
    wc.hIconSm       := 0;


  wc.hInstance := hInstance;
  wc.hIcon := LoadIcon(0, IDI_WINLOGO);
  wc.hCursor := LoadCursor(0, IDC_ARROW);
  if (registerclassex(wc) = 0) then exit;

  Hnd := CreateWindowEx(0,versionstring, 'svGE_Ext', WS_CAPTION or WS_SYSMENU, 0,
    0,100,100,0,0,hInstance, nil);
  if Hnd = 0 then fail;

  { Exit if already another instance active }
  if (bufsize = 0) then bufsize := buffersize_default;
  data.bufsize := bufsize;

  cap.version := 0;

  { Get hardware capabilities }

  if (waveoutgetdevcaps(WAVE_MAPPER,@waveoutcaps,sizeof(waveoutcaps)) = MMSYSERR_NOERROR)
  then
  with cap do
  begin

//    WAVE_FORMAT_
//  The delivered information is a piece of crap...
    minfreq         := 5000;
    monoplay.pref   := 48000;
    if checkcaps(96000,16,1) then monoplay.max := 96000     else
    if checkcaps(48000,16,1) then monoplay.max := 48000     else
    if checkcaps(44100, 8,1) then monoplay.max := 44100     else
    if checkcaps(22050, 8,1) then monoplay.max := 22050;

    monorecfreq     := 0;
    stereorecfreq   := 0;
    flags           := 0;
    if (waveoutcaps.wChannels >= 2) then
    begin
      flags := flags+snd_stereo;
      stereoplay.pref := 48000;
      if checkcaps(96000,16,2) then stereoplay.max := 96000     else
      if checkcaps(48000,16,2) then stereoplay.max := 48000     else
      if checkcaps(44100, 8,2) then stereoplay.max := 44100     else
      if checkcaps(22050, 8,2) then stereoplay.max := 22050;
    end else
    begin
      stereoplay.pref := 0;
      stereoplay.max  := 0;
    end;
    if (waveoutcaps.dwFormats and WAVE_FORMAT_4S16 <> 0) then
    begin
      flags := flags+snd_16bit;
      // This will return false; supported by extensible format; not implemented yet
      // W9x returns always true... bad...
      {if checkcaps(stereoplay.max,24,2) then flags := flags or snd_24bit;}
    end;

    cardstring      := 'WaveOut ('+waveoutcaps.szPname+')';
    wavetablesize   := 0;
  end

  else fail;

  cap.driverstring := versionstring;

  data.inchannels  := 0;
  data.outchannels := 0;
  initialized      := true;
  chain.next       := nil;
end;

destructor TsvSondDriver_WaveOut.done;
begin
  svGE_SoundDriver_WaveOut.done := true;
  if assigned(play.callt) then
  if (play.callt^.mixthread <> 0) then closehandle(play.callt^.mixthread);
  initialized := false;
  play.callt := nil;
  freemem(wavefmt);
  inherited done;
end;

function TsvSondDriver_WaveOut.getcapabilities(var tcap : tcardinfo) : boolean;
begin
  if not initialized then
  begin
    getcapabilities := false;
    exit;
  end else getcapabilities := true;
  tcap := cap;
end;


function TsvSondDriver_WaveOut.PlayBack_Start(freq,flags : longword) : boolean;
var
  res        : hresult;
begin
  Result := false;

  if (flags and snd_auto <> 0) then
  begin
    flags := cap.flags or flags;
    if (cap.flags and snd_stereo = 0) then
    flags := flags and not (snd_stereo or snd_prologic);
  end;

  flags := flags and not snd_signed;
  if (flags and (snd_16bit or snd_24bit) <> 0) then flags := flags or snd_signed;

  if (flags and snd_prologic <> 0) then flags := flags or snd_stereo;
  data.flags := flags;
  case flags and (snd_stereo or snd_prologic) of
    snd_mono   : begin
                   data.inchannels  := 2;
                   data.outchannels := 1;
                 end;
    snd_stereo : begin
                   data.inchannels  := 2;
                   data.outchannels := 2;
                 end;
    snd_stereo+snd_prologic :
                 begin
                   data.inchannels  := 3;
                   data.outchannels := 2;
                 end;
  end;

  if (freq = 0) then { Set frequency automatically }
  begin
    if (flags and snd_stereo <> 0) then freq := cap.stereoplay.pref
    else freq := cap.monoplay.pref;
  end;

  if outofspec(freq,flags) then exit;

  data.freq := freq;

  data.samplesize := 1;
  if (flags and snd_16bit <> 0) then data.samplesize := 2*data.outchannels
  else
  if (flags and snd_24bit <> 0) then data.samplesize := 3*data.outchannels;

  getmem(datap,data.bufsize*data.samplesize*2);
  getmem(data.buffer,data.bufsize*data.inchannels*4*2);
  getmem(buffer,data.bufsize*data.samplesize*2);
  fillchar(data.buffer^,data.bufsize*data.inchannels*2,0);


  if (data.flags and snd_signed <> 0) then
  begin
    if (data.flags and snd_24bit <> 0) then
      fill24(buffer,data.bufsize*data.samplesize*2,0) else
    if (data.flags and snd_16bit <> 0) then
      fillchar(buffer^,data.bufsize*data.samplesize*2,0) else
      fillchar(buffer^,data.bufsize*data.samplesize*4,0);
  end else
  begin
    if (data.flags and snd_24bit <> 0) then
      fill24(buffer,data.bufsize*data.samplesize*2,$EFFFFF) else
    if (data.flags and snd_16bit <> 0) then
      fillchar(buffer^,data.bufsize*data.samplesize*2,$EFFF) else
      fillchar(buffer^,data.bufsize*data.samplesize*4,$EF);
  end;


  // set wave format
  fillchar(wavefmt^,sizeof(wavefmt),0);
  with wavefmt^ do
  begin
    wformattag := WAVE_FORMAT_PCM;
    nchannels  := data.outchannels;

    if (data.flags and snd_24bit <> 0) then
      wBitsPerSample := 24 else
    if (data.flags and snd_16bit <> 0) then
      wBitsPerSample := 16 else wBitsPerSample := 8;

    nsamplespersec  := freq;
    nblockalign     := wbitspersample div 8 * data.outchannels;
    navgbytespersec := nsamplespersec * nblockalign;
  end;

  res := waveoutopen(@waveout,wave_mapper,wavefmt,dword(@waveoutproc),dword(hnd),0);
  if (res <> MMSYSERR_NOERROR) then exit;

  fillchar(wavehdr,sizeof(wavehdr),0);
  with wavehdr do
  begin
    lpData  := pchar(buffer);
    dwBufferLength := data.bufsize*data.samplesize*2;
    dwFlags := WHDR_BEGINLOOP or WHDR_ENDLOOP;
    dwLoops := $FFFFFFFF;
    dwUser  := 0;
  end;

  res := waveoutprepareheader(waveout,@wavehdr,sizeof(wavehdr));
  if (res <> MMSYSERR_NOERROR) then exit;

  if waveOutWrite(waveout,@wavehdr,sizeof(wavehdr)) <>  MMSYSERR_NOERROR then exit;

  play.callt := @self;

  // Set up mixing thread... will probably later changed to callback routines
  play.sleeptime := trunc(1000/(freq/data.bufsize)/2);
  mixthread := createthread(nil, 0, @mixproc, nil, 0, mixthreadid);
  setthreadpriority(mixthread,THREAD_PRIORITY_TIME_CRITICAL);
  if (mixthread = 0) then exit;
  data.freq := freq;
  Result := true;
end;

procedure TsvSondDriver_WaveOut.PlayBack_Stop;
begin
  if not initialized then exit;

  waveoutreset(waveout);
  waveoutclose(waveout);
  closehandle(mixthread);
  mixthread := 0;

  freemem(buffer);
  freemem(data.buffer);
  freemem(datap);
end;

var
  activeblock : longint = 0;

procedure TsvSondDriver_WaveOut.intrcallproc;
var
  p,p2,p3     : pointer;
  wavepos     : mmtime;

begin
  waveoutgetposition(waveout,@wavepos,sizeof(wavepos));
  if (int64((wavepos.sample mod (data.bufsize*data.samplesize*2)) div (data.bufsize*data.samplesize)) <> int64(activeblock)) then
  begin
      p  := datap;

      { Mix the output channels together }
      if (data.flags and snd_mixmanual = 0) then mixdata;
      p2 := getdatapointer;

      { Convert mixed data to required output format }
      if (data.flags and snd_prologic <> 0) then
      begin
        p3 := p2;
        if (data.flags and snd_signed <> 0) then
        begin
          if (data.flags and snd_24bit <> 0) then
            aud_s32_to_ds24(p2,p3,p,data.bufsize) else
          if (data.flags and snd_16bit <> 0) then
            aud_s32_to_ds16(p2,p3,p,data.bufsize) else
            aud_s32_to_ds8(p2,p3,p,data.bufsize);
        end else
        begin
          if (data.flags and snd_16bit <> 0) then
            aud_s32_to_dus16(p2,p3,p,data.bufsize) else
            aud_s32_to_dus8(p2,p3,p,data.bufsize);
        end;
      end else
      if (data.flags and snd_stereo <> 0) then
      begin
        if (data.flags and snd_signed <> 0) then
        begin
          if (data.flags and snd_24bit <> 0) then
            aud_s32_to_s24(p2,p,data.bufsize*data.samplesize div 3) else
          if (data.flags and snd_16bit <> 0) then
            aud_s32_to_s16(p2,p,data.bufsize*data.samplesize shr 1) else
            aud_s32_to_s8(p2,p,data.bufsize*data.samplesize);
        end else
        begin
          if (data.flags and snd_16bit <> 0) then
            aud_s32_to_us16(p2,p,data.bufsize*data.samplesize shr 1) else
            aud_s32_to_us8(p2,p,data.bufsize*data.samplesize);
        end;
      end else { We play mono :( }
      begin
        if (data.flags and snd_signed <> 0) then
        begin
          if (data.flags and snd_24bit <> 0) then
            aud_s32_to_sm24(p2,p,data.bufsize) else
          if (data.flags and snd_16bit <> 0) then
            aud_s32_to_sm16(p2,p,data.bufsize) else
            aud_s32_to_sm8(p2,p,data.bufsize);
        end else
        begin
          if (data.flags and snd_16bit <> 0) then
            aud_s32_to_usm16(p2,p,data.bufsize) else
            aud_s32_to_usm8(p2,p,data.bufsize);
        end;
      end;
      inc(data.intcount);
      move(datap^,pointer(longword(buffer)+longword(data.bufsize*data.samplesize*longword(activeblock)))^,
           data.bufsize*data.samplesize);
      activeblock := (activeblock+1) and 1;
  end;
end;

function TsvSondDriver_WaveOut.getversionstring : string;
begin
  getversionstring := versionstring;
end;

function TsvSondDriver_WaveOut.getnumofoutcontrols : word;
begin
  getnumofoutcontrols := 0;
end;

function TsvSondDriver_WaveOut.getoutcontroltype(num : word) : word;
begin
  getoutcontroltype := 0;
end;

function TsvSondDriver_WaveOut.getoutcontrolname(cnt : word) : string;
begin
  getoutcontrolname := 'N/A';
end;

function TsvSondDriver_WaveOut.getoutcontrolrange(cnt : word) : longint;
begin
  getoutcontrolrange := 0;
end;

function TsvSondDriver_WaveOut.getoutcontrol(cnt : word) : longint;
begin
  getoutcontrol := 0;
end;

function TsvSondDriver_WaveOut.setoutcontrol(cnt : word;val : longint) : boolean;
begin
  setoutcontrol := false;
end;

function TsvSondDriver_WaveOut.getbufpointer : pointer;
begin
  getbufpointer := pointer(longint(data.buffer)+int64(data.bufsize*data.samplesize)*int64(activeblock));
end;

end.

