{------------------------------------------------------------------------------}
{ SibVRV
{ svGE Unit
{ Created 12.03.2001 by Vereshagin Roman Vladimirovich.
{ History:
{  VR - Unit Created
{------------------------------------------------------------------------------}
unit svGE_SoundDataConvetations;
interface

procedure aud_us8_to_s16(source,dest : pointer;samples : longint);
procedure aud_s8_to_s16(source,dest : pointer;samples : longint);
procedure aud_us16_to_s16(source,dest : pointer;samples : longint);

procedure aud_s32_to_ds8(source1,source2,dest : pointer;samples : longint);
procedure aud_s32_to_dus8_fix(source1,source2,dest : pointer;samples : longint);
procedure aud_s32_to_dus8(source1,source2,dest : pointer;samples : longint);
procedure aud_s32_to_ds16(source1,source2,dest : pointer;samples : longint);
procedure aud_s32_to_dus16(source1,source2,dest : pointer;samples : longint);
procedure aud_s32_to_ds24(source1,source2,dest : pointer;samples : longint);

procedure aud_s32_to_s24(source,dest : pointer;samples : longint);
procedure aud_s32_to_sm24(source,dest : pointer;samples : longint);
procedure aud_s32_to_s16(source,dest : pointer;samples : longint);
procedure aud_s32_to_sm16(source,dest : pointer;samples : longint);
procedure aud_s32_to_us16(source,dest : pointer;samples : longint);
procedure aud_s32_to_usm16(source,dest : pointer;samples : longint);
procedure aud_s32_to_s8(source,dest : pointer;samples : longint);
procedure aud_s32_to_sm8(source,dest : pointer;samples : longint);
procedure aud_s32_to_us8_fix(source,dest : pointer;samples : longint);
procedure aud_s32_to_us8(source,dest : pointer;samples : longint);
procedure aud_s32_to_usm8(source,dest : pointer;samples : longint);

procedure delta8(source : pointer;samples : longint);
procedure delta16(source : pointer;samples : longint);

procedure fill24(dest : pointer;count,val : longint);

implementation

procedure aud_us8_to_s16(source,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx

  mov   edi,source
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_us8

  mov   esi,dest
@lp_us8:
  mov   al,0
  mov   ah,[edi]
  sub   ax,32768
  mov   [esi],ax
  add   esi,2
  inc   edi
  dec   ecx
  jnz   @lp_us8
@end_us8:

  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s8_to_s16(source,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx

  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s8

  mov   edi,source
  mov   esi,dest

  mov   al,0
@lp_s8:
  mov   ah,[edi]
  mov   [esi],ax
  add   esi,2
  inc   edi
  dec   ecx
  jnz   @lp_s8
@end_s8:

  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_us16_to_s16(source,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx

  mov   edi,source
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_us16

  mov   esi,dest
@lp_us16:
  mov   al,0
  mov   ax,[edi]
  sub   ax,32768
  mov   [esi],ax
  add   esi,2
  add   edi,2
  dec   ecx
  jnz   @lp_us16
@end_us16:

  pop   ecx
  pop   esi
  pop   edi
end;


procedure aud_s32_to_ds8(source1,source2,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx
  push  eax
  push  ebx

  mov   esi,dest
  mov   edi,source1
  mov   edx,source2
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s32ds8

@lp_s32ds8:
  mov   eax,[edi]
  mov   ebx,[edx+8]
  sub   eax,ebx
  cmp   eax,1FFFFFFFh
  jng   @na_s32ds8_1
    mov   eax,1FFFFFFFh
    jmp   @out_s32ds8_1
  @na_s32ds8_1:
  cmp   eax,0E0000001h
  jnl   @out_s32ds8_1
    mov   eax,0E0000001h
@out_s32ds8_1:

  shr   eax,22
  mov   [esi],al

  mov   eax,[edi+4]
  add   eax,ebx
  cmp   eax,1FFFFFFFh
  jng   @na_s32ds8_2
    mov   eax,1FFFFFFFh
    jmp   @out_s32ds8_2
  @na_s32ds8_2:
  cmp   eax,0E0000001h
  jnl   @out_s32ds8_2
    mov   eax,0E0000001h
@out_s32ds8_2:

  shr   eax,22
  mov   [esi+1],al

  add   edi,12
  add   edx,12
  add   esi,2
  dec   ecx
  jnz   @lp_s32ds8
@end_s32ds8:

  pop   ebx
  pop   eax
  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_dus8_fix(source1,source2,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx
  push  eax
  push  ebx

  mov   esi,dest
  mov   edi,source1
  mov   edx,source2
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s32du8

@lp_s32du8:
  mov   eax,[edi]
  mov   ebx,[edx+8]
  sub   eax,ebx
  cmp   eax,1FFFFFFFh
  jng   @na_s32du8_1
    mov   eax,1FFFFFFFh
    jmp   @out_s32du8_1
  @na_s32du8_1:
  cmp   eax,0E0000001h
  jnl   @out_s32du8_1
    mov   eax,0E0000001h
@out_s32du8_1:

  shr   eax,22
  add   al,128
  mov   [esi+1],al

  mov   eax,[edi+4]
  add   eax,ebx
  cmp   eax,1FFFFFFFh
  jng   @na_s32du8_2
    mov   eax,1FFFFFFFh
    jmp   @out_s32du8_2
  @na_s32du8_2:
  cmp   eax,0E0000001h
  jnl   @out_s32du8_2
    mov   eax,0E0000001h
@out_s32du8_2:

  shr   eax,22
  add   al,128
  mov   [esi],al

  add   edi,12
  add   edx,12
  add   esi,2
  dec   ecx
  jnz   @lp_s32du8
@end_s32du8:

  pop   ebx
  pop   eax
  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_dus8(source1,source2,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx
  push  eax
  push  ebx

  mov   esi,dest
  mov   edi,source1
  mov   edx,source2
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s32du8

@lp_s32du8:
  mov   eax,[edi]
  mov   ebx,[edx+8]
  sub   eax,ebx
  cmp   eax,1FFFFFFFh
  jng   @na_s32du8_1
    mov   eax,1FFFFFFFh
    jmp   @out_s32du8_1
  @na_s32du8_1:
  cmp   eax,0E0000001h
  jnl   @out_s32du8_1
    mov   eax,0E0000001h
@out_s32du8_1:

  shr   eax,22
  add   al,128
  mov   [esi],al

  mov   eax,[edi+4]
  add   eax,ebx
  cmp   eax,1FFFFFFFh
  jng   @na_s32du8_2
    mov   eax,1FFFFFFFh
    jmp   @out_s32du8_2
  @na_s32du8_2:
  cmp   eax,0E0000001h
  jnl   @out_s32du8_2
    mov   eax,0E0000001h
@out_s32du8_2:

  shr   eax,22
  add   al,128
  mov   [esi+1],al

  add   edi,12
  add   edx,12
  add   esi,2
  dec   ecx
  jnz   @lp_s32du8
@end_s32du8:

  pop   ebx
  pop   eax
  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_ds16(source1,source2,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx
  push  eax
  push  ebx

  mov   esi,dest
  mov   edi,source1
  mov   edx,source2
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s32ds16

@lp_s32ds16:
  mov   eax,[edi]
  mov   ebx,[edx+8]
  sub   eax,ebx
  cmp   eax,1FFFFFFFh
  jng   @na_s32d16_1
    mov   eax,1FFFFFFFh
    jmp   @out_s32d16_1
  @na_s32d16_1:
  cmp   eax,0E0000001h
  jnl   @out_s32d16_1
    mov   eax,0E0000001h
@out_s32d16_1:

  shr   eax,14
  mov   [esi],ax

  mov   eax,[edi+4]
  add   eax,ebx
  cmp   eax,1FFFFFFFh
  jng   @na_s32d16_2
    mov   eax,1FFFFFFFh
    jmp   @out_s32d16_2
  @na_s32d16_2:
  cmp   eax,0E0000001h
  jnl   @out_s32d16_2
    mov   eax,0E0000001h
@out_s32d16_2:

  shr   eax,14
  mov   [esi+2],ax

  add   edi,12
  add   edx,12
  add   esi,4
  dec   ecx
  jnz   @lp_s32ds16
@end_s32ds16:

  pop   ebx
  pop   eax
  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_dus16(source1,source2,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx
  push  eax
  push  ebx

  mov   esi,dest
  mov   edi,source1
  mov   edx,source2
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s32du16

@lp_s32du16:
  mov   eax,[edi]
  mov   ebx,[edx+8]
  sub   eax,ebx
  cmp   eax,1FFFFFFFh
  jng   @na_s32du16_1
    mov   eax,1FFFFFFFh
    jmp   @out_s32du16_1
  @na_s32du16_1:
  cmp   eax,0E0000001h
  jnl   @out_s32du16_1
    mov   eax,0E0000001h
@out_s32du16_1:

  shr   eax,14
  add   ax,32768
  mov   [esi],ax

  mov   eax,[edi+4]
  add   eax,ebx
  cmp   eax,1FFFFFFFh
  jng   @na_s32du16_2
    mov   eax,1FFFFFFFh
    jmp   @out_s32du16_2
  @na_s32du16_2:
  cmp   eax,0E0000001h
  jnl   @out_s32du16_2
    mov   eax,0E0000001h
@out_s32du16_2:

  shr   eax,14
  add   ax,32768
  mov   [esi+2],ax

  add   edi,12
  add   edx,12
  add   esi,4
  dec   ecx
  jnz   @lp_s32du16
@end_s32du16:

  pop   ebx
  pop   eax
  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;


procedure aud_s32_to_ds24(source1,source2,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx
  push  eax
  push  ebx

  mov   esi,dest
  mov   edi,source1
  mov   edx,source2
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s32ds24

@lp_s32ds24:
  mov   eax,[edi]
  mov   ebx,[edx+8]
  sub   eax,ebx
  cmp   eax,1FFFFFFFh
  jng   @na_s32d24_1
    mov   eax,1FFFFFFFh
    jmp   @out_s32d24_1
  @na_s32d24_1:
  cmp   eax,0E0000001h
  jnl   @out_s32d24_1
    mov   eax,0E0000001h
@out_s32d24_1:

  shr   eax,6
  mov   [esi],ax
  shr   eax,16
  mov   [esi+2],al

  mov   eax,[edi+4]
  add   eax,ebx
  cmp   eax,1FFFFFFFh
  jng   @na_s32d24_2
    mov   eax,1FFFFFFFh
    jmp   @out_s32d24_2
  @na_s32d24_2:
  cmp   eax,0E0000001h
  jnl   @out_s32d24_2
    mov   eax,0E0000001h
@out_s32d24_2:

  shr   eax,6
  mov   [esi+3],ax
  shr   eax,16
  mov   [esi+5],al

  add   edi,12
  add   edx,12
  add   esi,6
  dec   ecx
  jnz   @lp_s32ds24
@end_s32ds24:

  pop   ebx
  pop   eax
  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_s24(source,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx

  mov   edi,source
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s3224

  mov   esi,dest
@lp_s3224:
  mov   eax,[edi]

  cmp   eax,1FFFFFFFh
  jng   @na_s3224
    mov   eax,1FFFFFFFh
    jmp   @out_s3224
  @na_s3224:
  cmp   eax,0E0000001h
  jnl   @out_s3224
    mov   eax,0E0000001h
@out_s3224:

  shr   eax,6
  mov   [esi],ax
  shr   eax,16
  mov   [esi+2],al
  add   edi,4
  add   esi,3
  dec   ecx
  jnz   @lp_s3224
@end_s3224:

  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_sm24(source,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx

  mov   edi,source
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s32m24

  mov   esi,dest
@lp_s32m24:
  mov eax,[edi]

  cmp   eax,1FFFFFFFh
  jng   @na_s32m24_1
    mov   eax,1FFFFFFFh
    jmp   @out_s32m24_1
  @na_s32m24_1:
  cmp   eax,0E0000001h
  jnl   @out_s32m24_1
    mov   eax,0E0000001h
@out_s32m24_1:

  mov ebx,[edi+4]

  cmp   ebx,1FFFFFFFh
  jng   @na_s32m24_2
    mov   ebx,1FFFFFFFh
    jmp   @out_s32m24_2
  @na_s32m24_2:
  cmp   ebx,0E0000001h
  jnl   @out_s32m24_2
    mov   ebx,0E0000001h
@out_s32m24_2:

  add   eax,ebx
  shr   eax,6
  mov   [esi],ax
  shr   eax,16
  mov   [esi+2],al

  add   edi,8
  add   esi,3
  dec   ecx
  jnz   @lp_s32m24
@end_s32m24:

  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_s16(source,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx

  mov   edi,source
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s3216

  mov   esi,dest
@lp_s3216:
  mov   eax,[edi]

  cmp   eax,1FFFFFFFh
  jng   @na_s3216
    mov   eax,1FFFFFFFh
    jmp   @out_s3216
  @na_s3216:
  cmp   eax,0E0000001h
  jnl   @out_s3216
    mov   eax,0E0000001h
@out_s3216:

  shr   eax,14
  mov   [esi],ax
  add   edi,4
  add   esi,2
  dec   ecx
  jnz   @lp_s3216
@end_s3216:

  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_sm16(source,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx

  mov   edi,source
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s32m16

  mov   esi,dest
@lp_s32m16:
  mov   eax,[edi]

  cmp   eax,1FFFFFFFh
  jng   @na_s32m16_1
    mov   eax,1FFFFFFFh
    jmp   @out_s32m16_1
  @na_s32m16_1:
  cmp   eax,0E0000001h
  jnl   @out_s32m16_1
    mov   eax,0E0000001h
@out_s32m16_1:

  mov ebx,[edi+4]

  cmp   ebx,1FFFFFFFh
  jng   @na_s32m16_2
    mov   ebx,1FFFFFFFh
    jmp   @out_s32m16_2
  @na_s32m16_2:
  cmp   ebx,0E0000001h
  jnl   @out_s32m16_2
    mov   ebx,0E0000001h
@out_s32m16_2:

  shr   eax,14
  mov   [esi],ax
  add   edi,8
  add   esi,2
  dec   ecx
  jnz   @lp_s32m16
@end_s32m16:

  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_us16(source,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx

  mov   edi,source
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s32u16

  mov   esi,dest
@lp_s32u16:
  mov   eax,[edi]

  cmp   eax,1FFFFFFFh
  jng   @na_us3216
    mov   eax,1FFFFFFFh
    jmp   @out_us3216
  @na_us3216:
  cmp   eax,0E0000001h
  jnl   @out_us3216
    mov   eax,0E0000001h
@out_us3216:
  shr   eax,14

  add   ax,32768
  mov   [esi],ax
  add   edi,4
  add   esi,2
  dec   ecx
  jnz   @lp_s32u16
@end_s32u16:

  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_usm16(source,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx

  mov   edi,source
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s32um16

  mov   esi,dest
  xor   eax,eax
  xor   ebx,ebx
@lp_s32um16:
  mov   eax,[edi]

  cmp   eax,1FFFFFFFh
  jng   @na_us32m16_1
    mov   eax,1FFFFFFFh
    jmp   @out_us32m16_1
  @na_us32m16_1:
  cmp   eax,0E0000001h
  jnl   @out_us32m16_1
    mov   eax,0E0000001h
@out_us32m16_1:

  mov ebx,[edi+4]

  cmp   ebx,1FFFFFFFh
  jng   @na_us32m16_2
    mov   ebx,1FFFFFFFh
    jmp   @out_us32m16_2
  @na_us32m16_2:
  cmp   ebx,0E0000001h
  jnl   @out_us32m16_2
    mov   ebx,0E0000001h
@out_us32m16_2:

  shr   eax,14

  mov   [esi],ax
  add   edi,8
  add   esi,2
  dec   ecx
  jnz   @lp_s32um16
@end_s32um16:

  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_s8(source,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx

  mov   edi,source
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s32s8

  mov   esi,dest
@lp_s32s8:
  mov   eax,[edi]

  cmp   eax,1FFFFFFFh
  jng   @na_s328
    mov   eax,1FFFFFFFh
    jmp   @out_s328
  @na_s328:
  cmp   eax,0E0000001h
  jnl   @out_s328
    mov   eax,0E0000001h
@out_s328:

  shr   eax,22

  mov   [esi],al
  add   edi,4
  inc   esi
  dec   ecx
  jnz   @lp_s32s8
@end_s32s8:

  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_sm8(source,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx

  mov   edi,source
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s32m8

  mov   esi,dest
@lp_s32m8:
  mov   eax,[edi]

  cmp   eax,1FFFFFFFh
  jng   @na_s32m8_1
    mov   eax,1FFFFFFFh
    jmp   @out_s32m8_1
  @na_s32m8_1:
  cmp   eax,0E0000001h
  jnl   @out_s32m8_1
    mov   eax,0E0000001h
@out_s32m8_1:

  mov ebx,[edi+4]

  cmp   ebx,1FFFFFFFh
  jng   @na_s32m8_2
    mov   ebx,1FFFFFFFh
    jmp   @out_s32m8_2
  @na_s32m8_2:
  cmp   ebx,0E0000001h
  jnl   @out_s32m8_2
    mov   ebx,0E0000001h
@out_s32m8_2:

  add   eax,ebx
  shr   eax,23
  mov   [esi],al
  add   edi,8
  inc   esi
  dec   ecx
  jnz   @lp_s32m8
@end_s32m8:

  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_us8_fix(source,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx

  mov   edi,source
  mov   ecx,samples
  shr   ecx,1
  jz    @end_s32u8

  mov   esi,dest
@lp_s32u8:
  mov   eax,[edi]

  cmp   eax,1FFFFFFFh
  jng   @na_us328_1
    mov   eax,1FFFFFFFh
    jmp   @out_us328_1
  @na_us328_1:
  cmp   eax,0E0000001h
  jnl   @out_us328_1
    mov   eax,0E0000001h
@out_us328_1:

  shr   eax,22

  add   al,80h
  mov   [esi+1],al

  mov   eax,[edi+4]

  cmp   eax,1FFFFFFFh
  jng   @na_us328_2
    mov   eax,1FFFFFFFh
    jmp   @out_us328_2
  @na_us328_2:
  cmp   eax,0E0000001h
  jnl   @out_us328_2
    mov   eax,0E0000001h
@out_us328_2:
  add   eax,eax
  shr   eax,24

  add   al,80h
  mov   [esi],al

  add   edi,8
  add   esi,2
  dec   ecx
  jnz   @lp_s32u8
@end_s32u8:

  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_us8(source,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx

  mov   edi,source
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s32u8

  mov   esi,dest
@lp_s32u8:
  mov   eax,[edi]

  cmp   eax,1FFFFFFFh
  jng   @na_us328
    mov   eax,1FFFFFFFh
    jmp   @out_us328
  @na_us328:
  cmp   eax,0E0000001h
  jnl   @out_us328
    mov   eax,0E0000001h
@out_us328:
  shr   eax,22

  add   al,80h
  mov   [esi],al
  add   edi,4
  inc   esi
  dec   ecx
  jnz   @lp_s32u8
@end_s32u8:

  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure aud_s32_to_usm8(source,dest : pointer;samples : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx

  mov   edi,source
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_s32um8

  mov   esi,dest
  xor   eax,eax
  xor   ebx,ebx
@lp_s32um8:
  mov   eax,[edi]

  cmp   eax,1FFFFFFFh
  jng   @na_us32m8_1
    mov   eax,1FFFFFFFh
    jmp   @out_us32m8_1
  @na_us32m8_1:
  cmp   eax,0E0000001h
  jnl   @out_us32m8_1
    mov   eax,0E0000001h
@out_us32m8_1:

  mov ebx,[edi+4]

  cmp   ebx,1FFFFFFFh
  jng   @na_us32m8_2
    mov   ebx,1FFFFFFFh
    jmp   @out_us32m8_2
  @na_us32m8_2:
  cmp   ebx,0E0000001h
  jnl   @out_us32m8_2
    mov   ebx,0E0000001h
@out_us32m8_2:

  add   eax,ebx
  shr   eax,23
  add   al,80h

  mov   [esi],al
  add   edi,8
  inc   esi
  dec   ecx
  jnz   @lp_s32um8
@end_s32um8:

  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure fill24(dest : pointer;count,val : longint);assembler;
asm
  push  edi
  push  esi
  push  ecx
  push  edx

        mov   edi,dest

        mov   ecx,3
        mov   eax,count
        cdq
        div   ecx
        or    eax,eax
        jz    @end_f24
        mov   esi,val
        and   esi,0FFFFFFh
        mov   ebx,esi
        mov   ecx,esi
        shl   ecx,24
        or    ebx,ecx
        mov   ecx,esi
        mov   edx,esi
        shr   ecx,8
        shl   edx,16
        or    ecx,edx
        mov   edx,esi
        shr   edx,16
        shl   esi,8
        or    edx,esi

        mov   esi,eax

        shr   eax,2
        jz    @b12_f24

@lp_f24:
        mov   [edi],ebx
        mov   [edi+4],ecx
        mov   [edi+8],edx
        add   edi,12
        dec   eax
        jnz   @lp_f24

@b12_f24:
        and   esi,3
        jz    @end_f24

@lp2_f24:
        mov   [edi],bx
        mov   [edi+2],ch
        add   edi,3
        dec   esi
        jnz   @lp2_f24
@end_f24:

  pop   edx
  pop   ecx
  pop   esi
  pop   edi
end;

procedure delta8(source : pointer;samples : longint);assembler;
asm
  push  edi
  push  ecx
  push  ebx

  mov   edi,source
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_d8

  mov   bl,0
@lp_d8:
  mov   al,es:[edi]
  add   bl,al
  mov   es:[edi],bl
  inc   edi
  dec   ecx
  jnz   @lp_d8
@end_d8:

  pop   ebx
  pop   ecx
  pop   edi
end;

procedure delta16(source : pointer;samples : longint);assembler;
asm
  push  edi
  push  ecx
  push  ebx

  mov   edi,source
  mov   ecx,samples
  or    ecx,ecx
  jz    @end_d16

  mov   bx,0
@lp_d16:
  mov   ax,es:[edi]
  add   bx,ax
  mov   es:[edi],bx
  add   edi,2
  dec   ecx
  jnz   @lp_d16
@end_d16:

  pop   ebx
  pop   ecx
  pop   edi
end;

end.
