unit _load;

interface

uses _var, _scd, exgine, Graphics, Classes;

procedure LoadData; // Loading game resources

implementation

//----------------------------------------------------------------------------------------------------------------------------------------------------

procedure generate_text;  //  justify  
var
    bm:TBitmap;
    a,b,c,spc_count,spc_w:integer;
    s:string;
    tsl1:tstringlist;
begin
  getdata('text',ms);
  bm:=TBitmap.Create;
  bm.Width:=256;
  bm.Height:=1024;
  bm.Canvas.Brush.Color:=clblack;
  bm.Canvas.FillRect(rect(0,0,256,1024));
  bm.Canvas.Font.Color:=clWhite;
  tsl1:=tstringlist.Create;
  tsl.Clear;
  tsl.LoadFromStream(ms);
  bm.canvas.Font.Name:='Areal';
  bm.canvas.Font.Size:=14;
  for a:=0 to tsl.Count-1 do
  begin
    s:=tsl[a];
    tsl1.Clear;
    spc_count:=0;
    spc_w:=0;
    c:=0;
    if s[1]<>'*' then
    begin
    tsl1.Add('');
    for b:=1 to length(s) do
      begin

        if s[b]=' ' then
          begin
            tsl1.Add('');
            tsl1[tsl1.Count-1]:=tsl1[tsl1.Count-1]+' ';
            inc(spc_count);
            tsl1.Add('');
          end
          else
          tsl1[tsl1.Count-1]:=tsl1[tsl1.Count-1]+s[b];
      end;
    for b:=0 to tsl1.Count-1 do
      if (tsl1[b]<>' ') and (tsl1[b]<>'') then
        inc(c,bm.Canvas.TextWidth(tsl1[b]));
    if spc_count>0 then spc_w:=(254-c) div spc_count;
    //bm.Canvas.TextOut(300,a*20,inttostr(spc_w));
    c:=1;
    for b:=0 to tsl1.Count-1 do
      begin
      s:=tsl1[b];
      if s<>'' then
          if s=' ' then c:=c+spc_w
          else
          begin
            bm.Canvas.TextOut(c,a*22,s);
            inc(c,bm.Canvas.TextWidth(s));
          end;
      end;
    end
    else
  bm.Canvas.TextOut(1,a*22,copy(s,2,100));
  end;
  ms.Clear;
  bm.SaveToStream(ms);
  ms.Position:=0;
  tex.Free(swtext);
  t[swtext]:=tex.Load('text.bmp',ms.Memory,ms.size,false,false);
end;

//----------------------------------------------------------------------------------------------------------------------------------------------------

function loadTex(Name:string; mipmap:boolean=true):TTexture;
var sz:integer;
    pn:pointer;
begin
  sz:=getdata(name,pn);
  result:=tex.Load(pchar(name),pn,sz,true,mipmap);
end;

//----------------------------------------------------------------------------------------------------------------------------------------------------

function loadSnd(Name:string):TSound;
var sz:integer;
    pn:pointer;
begin
  sz:=getdata(name,pn);
  result:=snd.Load(pchar(name),pn,sz,0);
end;

//----------------------------------------------------------------------------------------------------------------------------------------------------

procedure LoadData;
var a:integer;
begin
for a:=0 to high(starsky[0]) do
  begin
    starsky[0,a]:=random(800); // x
    starsky[1,a]:=random(600); // y
    starsky[2,a]:=(random(200)+50)/255; // brightness
  end;
new_level:=true;
GetSCD('cr.scd'); // get resource file

generate_text;

t[s_bomb]:=loadsnd('bomb.wav');
s[s_zap]:=loadsnd('zap.wav');
s[s_expl]:=loadsnd('expl1.wav');
s[s_blip]:=loadsnd('blip.wav');
s[s_damage]:=loadsnd('damage.wav');
s[s_shot1]:=loadsnd('xwingshot1.wav');
s[s_shot2]:=loadsnd('xwingshot2.wav');
s[s_tie_shot2]:=loadsnd('tieshot2.wav');
s[s_tiefly0]:=loadsnd('tiefly0.wav');
s[s_tiefly1]:=loadsnd('tiefly1.wav');
s[s_r2d2]:=loadsnd('r2d2-1.wav');

t[swlogo]:=loadTex('swlogo.bmp');
t[xwing]:=loadTex('xwing.tga');
t[exh1]:=loadTex('exhaust1.bmp');
t[shot1]:=loadTex('shot1.bmp');
t[lives]:=loadTex('lives.bmp');
t[rpm]:=loadTex('rpm.bmp');
t[multishot]:=loadTex('multishot.bmp');
t[bomb]:=loadTex('bomb1.bmp');
t[enter]:=loadTex('enter.bmp');
t[esc]:=loadTex('esc.bmp');

for a:=0 to 17 do
  begin
    t[tief+a]:=loadTex('tief'+inttostr(a*10)+'.tga');
    t[tiei+a]:=loadTex('tieI'+inttostr(a*10)+'.tga');
    t[tieb+a]:=loadTex('tieB'+inttostr(a*10)+'.tga');
  end;

for a:=0 to 7 do
  t[spark+a]:=loadTex('spark'+inttostr(a)+'.bmp');

for a:=0 to 35 do
  begin
    t[blast+a]:=loadTex('blast'+inttostr(a+1)+'.bmp');
    t[expl+a]:=loadTex('expl'+inttostr(a+1)+'.bmp');
  end;

end;


//----------------------------------------------------------------------------------------------------------------------------------------------------

end.



