﻿unit uParticles;

interface
uses
  zglHeader;

const
  MAX_PARTICLES = 1024;

  pt_sopla   = 0; // :D
  pt_aisopla = 1;
  pt_boom    = 2;
  pt_boomps  = 3;
  pt_boomps2 = 4;
  pt_wave    = 5;
  pt_smoke   = 6;
  pt_fire    = 7;

type
  TParticle = record
    _type   : Byte;
    X, Y, Z : Single;
    Speed   : zglTPoint3D;
    Size    : Single;
    Alpha   : Single;
    Angle   : Single;
    red     : DWORD;
    green   : DWORD;
    blue    : DWORD;
end;
  
procedure particles_Add( aType : Byte; aX, aY, aZ : Single );
procedure particles_Del( i : Integer );
procedure particles_Draw;
procedure particles_Proc;
procedure particles_Sort( iLo, iHi : WORD );

var
  particles : array[ 0..MAX_PARTICLES - 1 ] of TParticle;
  pCount    : Integer = 0;
nomore : Boolean = FALSE;

implementation
uses
  uMain, uPlayer, uRes;

procedure particles_Add;
begin
  with particles[ pCount ] do
    begin
      _type := aType;
      X     := aX;
      Y     := aY;
      Z     := aZ;
      Alpha := 255;
      red   := 0;
      green := 0;
      blue  := 0;

      case aType of
        pt_sopla: Size := 0.07;
        pt_aisopla: Size := 0.07;
        pt_boom:
          begin
            Angle := random( 90 ) - 45;
            Size := 0.01;
            snd_Play( s_Explosion, aX - Player.Col.Position.X, aY - Player.Col.Position.Y, aZ - Player.Col.Position.Z );
          end;
        pt_boomps, pt_boomps2:
          begin
            Alpha := 255 - random( 100 );
            Size  := 0.07;
          end;
        pt_wave:
          begin
            Size := 0.01;
            Angle := random( 90 ) - 45;
          end;
        pt_smoke:
          begin
            Size  := 0.01;
            Speed.X := random( 5 ) + 1;
            Speed.Y := random( 5 ) / 100;
            Speed.Z := random( 5 ) / 1000; 
          end;
        pt_fire:
          begin
            Size  := 0.05;
            Speed.X := random( 5 ) + 5;
            Speed.Y := random( 5 ) / 100;
            Speed.Z := random( 5 ) / 1000; 
          end;
      end;
    end;

  INC( pCount );
  if aType = pt_boom Then particles_Add( pt_wave, aX, aY, aZ );
end;

procedure particles_Del;
begin
  particles[ i ] := particles[ pCount - 1 ];
  DEC( pCount );
end;

procedure particles_Draw;
  var
    i : Integer;
begin
  // Это все жутко не оптимизировано :)
  //if pCount > 2 Then particles_Sort( 0, pCount - 1 );
  zgl_Disable( DEPTH_MASK );
  obj3d_Begin( OBJ3D_TEXTURING or OBJ3D_BLEND );
  for i := 0 to pCount - 1 do
    with particles[ i ] do
      begin
        //if not frustum_PointIn( @frustum, X, Y, Z ) Then continue;
        obj3d_BindTexture( tex_particle[ _type ], 0 );
        case _type of
          pt_sopla, pt_aisopla:
            begin
              fx_SetBlendMode( FX_BLEND_ADD );
              obj3d_SetColor( $FF0000 + red + green - blue, m_Round( Alpha ) );
              ssprite3d_Draw( X, Y, Z, Size, Size, Size, @Camera.Matrix );
              fx_SetBlendMode( FX_BLEND_NORMAL );
            end;
          pt_boom:
            begin
              obj3d_Move( X, Y, Z );
              fx_SetBlendMode( FX_BLEND_ADD );
              obj3d_SetColor( $FFFFFF, m_Round( Alpha ) );
              pr3d_Sphere( Size, 16 );
              obj3d_Move( -X, -Y, -Z );
            end;
          pt_boomps, pt_boomps2:
            begin
              fx_SetBlendMode( FX_BLEND_ADD );
              obj3d_SetColor( $FFFFFF, m_Round( Alpha ) );
              ssprite3d_Draw( X, Y, Z, Size, Size, Size, @Camera.Matrix );
              fx_SetBlendMode( FX_BLEND_NORMAL );
            end;
          pt_wave:
            begin
              obj3d_Move( X, Y, Z );
              fx_SetBlendMode( FX_BLEND_ADD );
              obj3d_SetColor( $FFFFFF, m_Round( Alpha ) );
              obj3d_Rotate( 90, AX );
              obj3d_Rotate( Angle, AY );
              pr3d_Plane( Size, Size );
              fx_SetBlendMode( FX_BLEND_NORMAL );
              obj3d_Rotate( -Angle, AY );
              obj3d_Rotate( -90, AX );
              obj3d_Move( -X, -Y, -Z );
            end;
          pt_smoke:
            begin
              obj3d_SetColor( $FFFFFF, m_Round( Alpha ) );
              ssprite3d_Draw( X, Y, Z, Size, Size, Size, @Camera.Matrix );
            end;
          pt_fire:
            begin
              fx_SetBlendMode( FX_BLEND_ADD );
              obj3d_SetColor( $FFFFFF, m_Round( Alpha ) );
              ssprite3d_Draw( X, Y, Z, Size, Size, Size, @Camera.Matrix );
              fx_SetBlendMode( FX_BLEND_NORMAL );
            end;
        end;
      end;
  obj3d_End;
  zgl_Enable( DEPTH_MASK );

  obj3d_SetColor( $FFFFFF, 255 );
end;

procedure particles_Proc;
  var
    i : Integer;
begin
  i := 0;
  while i < pCount do
    with particles[ i ] do
    case _type of
      pt_sopla, pt_aisopla:
        begin
          if red   < $0000FF Then INC( red,   $000022 );
          if green < $00FF00 Then INC( green, $002200 );
          if blue  < $FF0000 Then INC( blue,  $220000 );
          if red   > $0000FF Then red   := $0000FF;
          if green > $00FF00 Then green := $00FF00;
          if blue  > $FF0000 Then blue  := $FF0000;
          Alpha := Alpha - 25;
          if Alpha < 0 Then
            begin
              particles_Del( i );
              DEC( i );
            end;
          if _type = pt_sopla Then
            Z := Z + random( 5 ) / 1000
          else
            Z := Z - random( 5 ) / 1000;
          INC( i );
        end;
      pt_boom:
        begin
          Size := Size + 0.05;

          particles_Add( pt_boomps, X + ( random( 100 ) - 50 ) / 100, Y + ( random( 100 ) - 50 ) / 100, Z + ( random( 100 ) - 50 ) / 100 );

          Alpha := Alpha - 10;
          if Alpha < 0 Then
            begin
              particles_Del( i );
              DEC( i );
            end;

          INC( i );
        end;
      pt_boomps, pt_boomps2:
        begin
          if _type = pt_boomps Then
            Size := Size + 0.05
          else
            Size := Size + 0.025;

          Alpha := Alpha - 15;
          if Alpha < 0 Then
            begin
              particles_Del( i );
              DEC( i );
            end;

          INC( i );
        end;
      pt_wave:
        begin
          Size := Size + 0.075;

          Alpha := Alpha - 5;
          if Alpha < 0 Then
            begin
              particles_Del( i );
              DEC( i );
            end;

          INC( i );
        end;
      pt_smoke, pt_fire:
        begin
          Size := Size + 0.01;
          Y    := Y + Speed.Y;

          Alpha := Alpha - Speed.X;
          if Alpha < 0 Then
            begin
              particles_Del( i );
              DEC( i );
            end;

          INC( i );
        end;
    end;
  if pCount > 2 Then particles_Sort( 0, pCount - 1 );
end;

procedure particles_Sort;
  var
    Lo, Hi : WORD;
    T      : TParticle;
    Mid    : Single;
begin
  Lo := iLo;
  Hi := iHi;
  Mid := particles[ ( Lo + Hi ) shr 1 ].Z;

  repeat
    while particles[ Lo ].Z < Mid do INC( Lo );
    while particles[ Hi ].Z > Mid do DEC( Hi );
    if Lo <= Hi then
      begin
        T               := particles[ Lo ];
        particles[ Lo ] := particles[ Hi ];
        particles[ Hi ] := T;
        INC( Lo );
        DEC( Hi );
      end;
  until Lo > Hi;

  if Hi - iLo > 1 Then
    if Hi > iLo Then particles_Sort( iLo, Hi );
  if iHi - Lo > 1 Then
    if Lo < iHi Then particles_Sort( Lo, iHi );
end;

end.
