unit uMain;

interface
uses
  zglHeader,
  {$IFDEF LINUX}
  zglModPlug
  {$ENDIF}
  {$IFDEF WIN32}
  uFMOD
  {$ENDIF};

procedure main_Init;
procedure main_Draw;
procedure main_Proc;
procedure main_Exit;

var
  frustum : zglTFrustum;
  plane   : DWORD;

implementation
uses
  uOptions, uLevel, uAI, uPlayer, uBonuses, uBullets, uParticles, uHUD, uRes;

procedure main_Init;
  var
    i : Integer;
begin
  //zgl_Enable( CORRECT_RESOLUTION );
  //scr_CorrectResolution( 1024, 768 );
  //options_Set;
  wnd_SetCaption( 'Z-Project' );

  tex_SetAnisotropy( oAnisotropy );
  snd_Init;
  res_Load;

  zBuffer_SetDepth( 0.1, 100 );
  //fog_SetMode( FOG_MODE_LINEAR );
  //fog_SetColor( $F0F0F0 );
  //fog_SetBeginEnd( 15, 35 );
  zgl_Disable( COLOR_BUFFER_CLEAR );

  Camera.Rotation.Y :=   90 * ( 3.14 / 180 );
  Camera.Rotation.X := - 35 * ( 3.14 / 180 );
  Camera.Position.Y := 50;
  Camera.Position.Y := 3.5;
  Camera.Position.Z := 125;

  mouse_Lock;

  player_Add;
  bonuses_Add( bst_Weapon, 0, 0, 100 );
  for i := 0 to 100 do
    enemies_Add( random( 3 ), 1, ( random( 8 ) - 4 ) * 1.1, 0.1, -random( 500 ) + 100 );

  {$IFDEF LINUX}
  modplug_Init;
  modplug_PlayFile( './data/sfx/music.xm', TRUE );
  {$ENDIF}
  {$IFDEF WIN32}
  uFMOD_PlaySong( PChar( './data/sfx/music.xm' ), 0, XM_FILE );
  {$ENDIF}
//  lstart := timer_GetTicks;
end;

procedure main_Draw;
begin
  Set3DMode( 45 );

  cam3d_Set( @Camera );

  frustum_Calc( @frustum );

  //fog_Enable;
  obj3d_Begin( OBJ3D_MTEXTURING or OBJ3D_WIRE_FRAME * Byte( debug ) );
    obj3d_BindTexture( tex_GMap01, 0 );
    obj3d_BindTexture( tex_Detail, 1 );
    obj3d_Move( 0, -30, 0 );
    heightmap_Draw( hm_Map01 );
  obj3d_End;

  player_Draw;
  enemies_Draw;
  //fog_Disable;
  bonuses_Draw;
  particles_Draw;
  bullets_Draw;

  hud_Draw;
end;

procedure main_Proc;
begin
  if Player.Life > 0 Then
    begin
      Camera.Position.Z     := Camera.Position.Z     - 0.02;
      Player.Col.Position.Z := Player.Col.Position.Z - 0.02;
    end;

  player_Proc;

  if Player.Life <= 0 Then
    begin
      if random( 5 ) = 0 Then
        particles_Add( pt_smoke, Player.Col.Position.X, Player.Col.Position.Y - 0.1, Player.Col.Position.Z + random( 3 ) / 10 );
      if random( 6 ) = 0 Then
        particles_Add( pt_fire, Player.Col.Position.X, Player.Col.Position.Y + 0.1, Player.Col.Position.Z + 0.1 );
    end;

  enemies_Proc;
  bonuses_Proc;
  particles_Proc;
  bullets_Proc;
//  level_Proc;
  mouse_Lock;

  if key_Down( K_ESCAPE ) Then zgl_Exit;
  if key_Up( K_F10 ) Then Player.Life := 0;
  if key_Up( K_F11 ) Then
    begin
      debug := not debug;
      if debug Then zgl_Enable( COLOR_BUFFER_CLEAR ) else zgl_Disable( COLOR_BUFFER_CLEAR )
    end;

  key_ClearState;
  mouse_ClearState;
end;

procedure main_Exit;
begin
  heightmap_Free( hm_Map01 );
end;

end.
