unit uBullets;

{$IFDEF FPC}
  {$MODE DELPHI}
{$ENDIF}

interface
uses
  zglHeader;

const
  MAX_BULLETS = 5120;

type
  TBullet = record
    _type    : Byte;
    Col      : zglTSphere;
    Demage   : Integer;
    byPlayer : Boolean;
    Move     : zglTPoint3D;
end;

procedure bullets_Add( aType : Byte; aX, aY, aZ : Single; abyPlayer : Boolean = FALSE );
procedure bullets_Del( i : Integer );
procedure bullets_Draw;
procedure bullets_Proc;

var
  bullets : array[ 0..MAX_BULLETS - 1 ] of TBullet;
  bCount  : Integer = 0;

implementation
uses
  uMain, uWeapon, uAI, uPlayer, uParticles, uRes;

procedure bullets_Add;
begin
  with bullets[ bCount ] do
    begin
      _type          := aType;
      byPlayer       := abyPlayer;
      Col.Position.X := aX;
      Col.Position.Y := aY;
      Col.Position.Z := aZ;

      case aType of
        wt_Simple:
          begin
            Col.Radius := 0.05;
            if abyPlayer Then
              Move.Z   := -0.25
            else
              Move.Z   := 0.25;
            Demage     := 25;
          end;
      end;
    end;

  INC( bCount );
end;

procedure bullets_Del;
begin
  bullets[ i ] := bullets[ bCount - 1 ];
  DEC( bCount );
end;

procedure bullets_Draw;
  var
    i : Integer;
begin
  obj3d_Begin( OBJ3D_TEXTURING or OBJ3D_BLEND );
  for i := 0 to bCount - 1 do
    with bullets[ i ] do
      begin
        if byPlayer Then
          obj3d_BindTexture( tex_bullet[ _type ], 0 )
        else
          obj3d_BindTexture( tex_ebullet[ _type ], 0 );
        case _type of
          wt_simple:
            begin
              fx_SetBlendMode( FX_BLEND_ADD );
              ssprite3d_Draw( Col.Position.X, Col.Position.Y, Col.Position.Z, Col.Radius * 2, Col.Radius * 2, Col.Radius * 2, @Camera.Matrix );
              fx_SetBlendMode( FX_BLEND_NORMAL );
            end;
        end;
      end;
  obj3d_End;
end;

procedure bullets_Proc;
  var
    i, j, k : Integer;
begin
  i := 0;
  while i < bCount do
    with bullets[ i ] do
      begin
        case _type of
          wt_Simple:
            begin
            end;
        end;
        Col.Position := vector_Add( Col.Position, Move );

        if ( Col.Position.Z < -16 + Camera.Position.Z ) Then
          begin
            bullets_Del( i );
            DEC( i );
          end;
        if ( Col.Position.Z > Camera.Position.Z ) Then
          begin
            bullets_Del( i );
            DEC( i );
          end;

        for j := 0 to eCount - 1 do
          if ( not enemies[ j ].Kill ) and ( byPlayer ) Then
          if col3d_AABBVsSphere( @enemies[ j ].Col, @Col ) Then
            begin
              for k := 0 to 4 do
                particles_Add( pt_boomps2,
                               Col.Position.X + ( random( 25 ) - 12 ) / 100,
                               Col.Position.Y + ( random( 25 ) - 12 ) / 100,
                               Col.Position.Z + ( random( 25 ) - 12 ) / 100 );
              DEC( enemies[ j ].Life, Demage );
              bullets_Del( i );
              DEC( i );
              break;
            end;

          if not byPlayer Then
          if col3d_AABBVsSphere( @Player.Col, @Col ) Then
            begin
              for k := 0 to 4 do
                particles_Add( pt_boomps2,
                               Col.Position.X + ( random( 25 ) - 12 ) / 100,
                               Col.Position.Y + ( random( 25 ) - 12 ) / 100,
                               Col.Position.Z + ( random( 25 ) - 12 ) / 100 );
              DEC( Player.Life, Demage );
              bullets_Del( i );
              DEC( i );
            end;

        INC( i );
      end;
end;

end.
