unit uAI;

interface
uses
  zglHeader,
  uWeapon;

const
  MAX_ENEMIES = 101;

  et_alien01 = 0;
  et_alien02 = 1;
  et_alien03 = 2;

  mm_simple  = 1;
  mm_l2r     = 2;
  mm_r2l     = 3;

type
  TEnemy = record
    _type  : Byte;
    Col    : zglTAABB;
    Matrix : zglTMatrix4f;
    Angle  : Single;

    Life   : Integer;
    Kill   : Boolean;
    Weapon : TWeapon;
    mMode  : Byte;
end;

procedure enemies_Add( aType, amMode : Byte; aX, aY, aZ : Single );
procedure enemies_Del( i : Integer );
procedure enemies_Draw;
procedure enemies_Proc;

var
  enemies : array[ 0..MAX_ENEMIES - 1 ] of TEnemy;
  eCount  : Integer = 0;

implementation
uses
  uMain, uPlayer, uParticles, uRes;

procedure enemies_Add;
begin
  with enemies[ eCount ] do
    begin
      _type          := aType;
      Col.Position.X := aX;
      Col.Position.Y := aY;
      Col.Position.Z := aZ;
      mMode          := amMode;

      case aType of
        et_alien01:
          begin
            Life       := 75;
            Col.Size.X := 0.6;
            Col.Size.Y := 0.1;
            Col.Size.Z := 0.3;
            weapon_Init( Weapon, wt_Simple2, FALSE );
          end;
        et_alien02:
          begin
            Life       := 100;
            Col.Size.X := 0.6;
            Col.Size.Y := 0.1;
            Col.Size.Z := 0.3;
            weapon_Init( Weapon, wt_Simple2, FALSE );
          end;
        et_alien03:
          begin
            Life       := 250;
            Col.Size.X := 0.6;
            Col.Size.Y := 0.1;
            Col.Size.Z := 0.75;
            weapon_Init( Weapon, wt_Simple2, FALSE );
          end;
      end;
    end;

  INC( eCount );
end;

procedure enemies_Del;
begin
  enemies[ i ] := enemies[ eCount - 1 ];
  DEC( eCount );
end;

procedure enemies_Draw;
  var
    i : Integer;
begin
  for i := 0 to eCount - 1 do
    with enemies[ i ] do
      begin
        if not frustum_BoxIn( @frustum, Col.Position.X, Col.Position.Y, Col.Position.Z, Col.Size.X, Col.Size.Y, Col.Size.Z ) Then continue;
        obj3d_Begin( OBJ3D_TEXTURING or OBJ3D_CULL_FACE );
          obj3d_MulMatrix( @Matrix );

          obj3d_BindTexture( tex_alien[ _type ], 0 );
          smesh_Draw( sm_alien[ _type ] );

          if debug Then
            begin
              obj3d_Disable( OBJ3D_TEXTURING );
              obj3d_Enable( OBJ3D_WIRE_FRAME );
              pr3d_AABB( Col.Size.X, Col.Size.Y, Col.Size.Z );
              obj3d_Disable( OBJ3D_WIRE_FRAME );
            end;
        obj3d_End;
      end;
end;

procedure enemies_Proc;
  var
    i  : Integer;
    pv : zglTPoint3D;
begin
  i := 0;
  while i < eCount do
    with enemies[ i ] do
      begin
        if Kill then
          begin
            enemies_Del( i );
            continue;
          end;
        if Life < 0 Then
          begin
            particles_Add( pt_boom, Col.Position.X, Col.Position.Y, Col.Position.Z );
            Kill := TRUE;
            continue;
          end;

        case mMode of
          mm_simple: Col.Position.Z := Col.Position.Z + 0.02;
          mm_l2r:
            begin
              Angle := -15;
              Col.Position.X := Col.Position.X + 0.1;
              Col.Position.Z := Col.Position.Z + 0.1;
            end;
          mm_r2l:
            begin
              Angle := 15;
              Col.Position.X := Col.Position.X - 0.1;
              Col.Position.Z := Col.Position.Z + 0.1;
            end;
        end;

        case _type of
          et_alien01, et_alien02:
            begin
              matrix4f_Translate( @Matrix, Col.Position.X, Col.Position.Y, Col.Position.Z );
              matrix4f_Rotate( @Matrix, 0, 180 * cv_pi180, Angle * cv_pi180 );

              if frustum_BoxIn( @frustum, Col.Position.X, Col.Position.Y, Col.Position.Z, Col.Size.X, Col.Size.Y, Col.Size.Z ) Then
                begin
                  pv.X := 0.1;
                  pv.Y := 0;
                  pv.Z := 0.35;
                  pv := vector_MulM4f( pv, @Matrix );
                  particles_Add( pt_aisopla, pv.X, pv.Y, pv.Z );
                  pv.X := -0.1;
                  pv.Y :=  0;
                  pv.Z :=  0.35;
                  pv := vector_MulM4f( pv, @Matrix );
                  particles_Add( pt_aisopla, pv.X, pv.Y, pv.Z );
                end;

              if vector_FDistance( Col.Position, Player.Col.Position ) < 100 Then
                begin
                  pv.X := -0.5;
                  pv.Y := 0;
                  pv.Z := -0.4;
                  pv := vector_MulM4f( pv, @Matrix );
                  weapon_Fire( Weapon, pv.X, pv.Y, pv.Z );

                  pv.X := 0.5;
                  pv.Y := 0;
                  pv.Z := -0.4;
                  pv := vector_MulM4f( pv, @Matrix );
                  weapon_Fire( Weapon, pv.X, pv.Y, pv.Z );
                end;
            end;
          et_alien03:
            begin
              matrix4f_Translate( @Matrix, Col.Position.X, Col.Position.Y, Col.Position.Z );
              matrix4f_Rotate( @Matrix, 0, 180 * cv_pi180, 0 );

              if frustum_BoxIn( @frustum, Col.Position.X, Col.Position.Y, Col.Position.Z, Col.Size.X, Col.Size.Y, Col.Size.Z ) Then
                begin
                  pv.X := 0.47;
                  pv.Y := 0.05;
                  pv.Z := 0.75;
                  pv := vector_MulM4f( pv, @Matrix );
                  particles_Add( pt_aisopla, pv.X, pv.Y, pv.Z );
                  pv.X := -0.47;
                  pv.Y :=  0.05;
                  pv.Z :=  0.75;
                  pv := vector_MulM4f( pv, @Matrix );
                  particles_Add( pt_aisopla, pv.X, pv.Y, pv.Z );
                end;

              if vector_FDistance( Col.Position, Player.Col.Position ) < 100 Then
                begin
                  pv.X := -0.5;
                  pv.Y := 0;
                  pv.Z := -0.4;
                  pv := vector_MulM4f( pv, @Matrix );
                  weapon_Fire( Weapon, pv.X, pv.Y, pv.Z );

                  pv.X := 0.5;
                  pv.Y := 0;
                  pv.Z := -0.4;
                  pv := vector_MulM4f( pv, @Matrix );
                  weapon_Fire( Weapon, pv.X, pv.Y, pv.Z );
                end;
            end;
        end;

        if Col.Position.Z - Col.Size.Z > Camera.Position.Z Then Kill := TRUE;
        if col3d_AABBVsAABB( @Col, @Player.Col ) Then
          begin
            Player.Life := Player.Life - 500;
            particles_Add( pt_boom, Col.Position.X, Col.Position.Y, Col.Position.Z );
            Kill := TRUE;
          end;
        INC( i );
      end;
end;

end.
