unit M_Game;

interface
uses
 LexUtils, OMEGA, gh_OMEGA, Setup;
type
  TFire = record
   X,Y : single;
   Boom, A : byte;
  end;

  TPerson = record
    D : oeRect;
    T, Dem, A, AA, MofF, Z : byte;
    Live : integer;
    F : array of TFire;
    VX : shortint;
  end;

const
  MofT = 11;
  TexStar  = 1;
  Texkomet = 2;
  TexVstar = 3;
  TexCdmlex = 4;
var
 Texture : array[1..MofT] of PTexture;
 cdmlexA, cdmlexN, LEvel, MofB : byte;
 Player : TPerson;
 SHofBot: array[1..4] of TPerson;
 Bot : array of TPerson;

 Key : array[1..3] of Byte;

Procedure LoadFiles;
Procedure GameDraw;
Procedure StartGame;
Procedure AddBots;

implementation
uses
  M_Proc;


Procedure LoadFiles;
var
  Flag : integer;
  S : TGHStandart;
  C : TGHCapt;
begin
  Flag:=TEX_DEFAULT_2D or TEX_USEMASK;

  Tex_LoadMaskFromFile('Data\star.gif');
  Texture[1]:=Tex_LoadFromFile('Data\star.gif', -1, Flag);

  Tex_LoadMaskFromFile('Data\komet.gif');
  Texture[2]:=Tex_LoadFromFile('Data\komet.gif', -1, Flag);

  Tex_LoadMaskFromFile('Data\vstar.gif');
  Texture[3]:=Tex_LoadFromFile('Data\vstar.gif', -1, Flag);

  Tex_LoadMaskFromFile('Data\cdmlex.gif');
  Texture[4]:=Tex_LoadFromFile('Data\cdmlex.gif', -1, Flag);
  Omega.Tex_SetFramesSize(Texture[4], 512, 128);

  Texture[5]:=Tex_LoadFromFile('Data\hero.gif', 0, TEX_DEFAULT_2D );
  Omega.Tex_SetFramesSize(Texture[5], 54, 128);
  Texture[6]:=Tex_LoadFromFile('Data\krevetko.gif', 0, TEX_DEFAULT_2D );
  Omega.Tex_SetFramesSize(Texture[6], 73, 128);
  Texture[7]:=Tex_LoadFromFile('Data\krevetko2.gif', 0, TEX_DEFAULT_2D );
  Omega.Tex_SetFramesSize(Texture[7], 73, 128);
  Texture[8]:=Tex_LoadFromFile('Data\crab.gif', 0, TEX_DEFAULT_2D );
  Omega.Tex_SetFramesSize(Texture[8], 73, 128);
  Texture[9]:=Tex_LoadFromFile('Data\BadaBoom.jpg', -1, TEX_DEFAULT_2D );
  Omega.Tex_SetFramesSize(Texture[9], 64, 64);
  Texture[10]:=Tex_LoadFromFile('Data\fire.gif', 0, TEX_DEFAULT_2D );
  Texture[11]:=Tex_LoadFromFile('Data\kislot.gif', 0, TEX_DEFAULT_2D );

  CreatGHFont('Data\font.gif');
//  CreatGHScin('Data\1.gif',4,2);
  CreatGHLayer;
  gh_OMEGA.UsedLayer:=-1;

  C.Sz:=2;
  C.Ft:=0;
  C.Tx :='   ';
  S.D.X:= 0;
  S.D.Y:= WinH - 150;
  S.D.W:=WinW div 2;

  S.L:=0;
  S.F:=-1;
  S.GHType:=tLabel;
  CreatGHObj(S,C);

  S.D.X:= -100;
  S.D.Y:= 100;
  C.Sz:=3;
  C.Col:=100;
  C.Tx :='   ';
  CreatGHObj(S,C);

  Key[1]:=K_A;
  Key[2]:=K_W;
  Key[3]:=K_D;

  CreatGHColor( $FFFFFF, $1199FF, $FF9FFF);
  CreatGHColor( $C2D6C0, $DAE6D9, $E8EEE9);

  CreatGHLayer;
  S.L:=1;

  C.Tx :=char(Key[1]);
  C.Col:=0;
  C.Sz:=1;

  S.D.X:= 10;
  S.D.Y:= WinH - 50;
  S.D.W:=30;
  S.D.H:=30;
  S.SI:=1;
  S.A:=220;
  S.GHDV:=colored;
  S.GHType:=tButton;
  CreatGHObj(S,C);

  S.D.X:= 50;
  C.Tx:=char(Key[2]);
  CreatGHObj(S,C);
  S.D.X:= 90;
  C.Tx:=char(Key[3]);
  CreatGHObj(S,C);

  S.D.X:= 250;
  S.D.W:= 150;
  C.Tx:= ': 100';

  CreatGHObj(S,C);

  SHofBot[1].D.Width:=80;
  SHofBot[1].D.Height:=80;
  SHofBot[1].Live:=30;
  SHofBot[1].A:=1;
  SHofBot[1].Dem:=2;
  SHofBot[1].T:=6;
  SHofBot[1].MofF:=10;

  SHofBot[2].D.Width:=80;
  SHofBot[2].D.Height:=80;
  SHofBot[2].Live:=40;
  SHofBot[2].A:=1;
  SHofBot[2].Dem:=3;
  SHofBot[2].T:=7;
  SHofBot[2].MofF:=10;

  SHofBot[3].D.Width:=100;
  SHofBot[3].D.Height:=100;
  SHofBot[3].Live:=50;
  SHofBot[3].A:=1;
  SHofBot[3].Dem:=5;
  SHofBot[3].T:=8;
  SHofBot[3].MofF:=15;

  Player.D.X:= (WinW - Player.D.Width) / 2;
end;

Procedure AddBots;
var
  I, X, Y : integer;
begin
  Y:=50;
  X:=100;
  MofB:=Level*2 + 1;
  setLength(Bot, MofB);
  For I:=0 to Level*2 do
  begin
    Bot[I]:=SHofBot[random(3)+1];
    Bot[I].VX:=5;
    Bot[I].D.X:=X;
    Bot[I].D.Y:=Y;
    inc(X, round(Bot[I].D.Width)+10);
    if X>WinW-110 then
      begin
        inc(Y,110);
        X:=100;
      end;
  end;
end;

Procedure StartGame;
begin
  TofG:=10;
  gh_OMEGA.UsedLayer:=1;
  Player.Dem:=10;
  Player.D.Width:=WinW/20;
  Player.D.Height:=2*Player.D.Width;

  Player.D.Y:= WinH - Player.D.Height -70;
  Player.A:=1;
  Player.Live:=100;
  Level:=1;
  Player.MofF:=30;
  GHLayer[0].GHObj.GHLabel[1].GHCapt.Tx:='  ';
  AddBots;
end;


Procedure GameDraw;
var
  I, V, FL : integer;
  RA : byte;
begin

  GHLayer[1].GHObj.GHButton[3].Capt.Tx:=': '+Int2S(Player.Live);
  for I:=0 to length(Bot)-1 do
  with Bot[I] do
    begin
      for V:=0 to length(Bot[I].F)-1 do
      with Bot[I].F[V] do
      case Boom of
        0 : Omega.SSprite_Draw(Texture[11], X, Y, 10, 18);
        1 : Omega.ASprite_Draw(Texture[9], X, Y, 30, 30, A);
        2 : Omega.ASprite_Draw(Texture[9], X, Y, 70, 70, A);
      end;
      if Live>0 then
      Omega.ASprite_Draw(Texture[T], D.X, D.Y, D.Width, D.Height, A);
    end;

  for I:=0 to length(Player.F)-1 do
  with Player.F[I] do
    case Boom of
      0 : Omega.SSprite_Draw(Texture[10], X, Y, 10, 18);
      1 : Omega.ASprite_Draw(Texture[9], X, Y, 30, 30, A);
      2 : Omega.ASprite_Draw(Texture[9], X, Y, 70, 70, A);
    end;

  with Player do
  if Live>0 then
  Omega.ASprite_Draw(Texture[5], D.X, D.Y, D.Width, D.Height, A);

end;



end.
