unit triGalax;

{
:
1) 
3)   ????
}

interface

uses
  // -
  Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Windows,
  //  ɨ,         . 
  GLScene, GLObjects, GLMisc, GLWin32Viewer, GLCadencer, GLKeyBoard, AsyncTimer,
  GLCrossPlatform, GLTexture, GLGraphics, GLCollision, GLBehaviours,
  GLHUDObjects, GLBitmapFont, GLWindowsFont, GLGameMenu,
  //   SibVRV     modarhives.com  
  svFiles, svOpenGL1x, svStrings, svVectorTypes,
  svErrorStrings, svGE_SoundDriverClass, svGE_SoundObjects_Modules,
  svGE_SoundChannels, svGE_SoundDataConvetations, svGE_SoundDriver_WaveOut;

type
  TfrmMain = class(TForm)
    GLS1: TGLScene;                 //  
    Viewer1: TGLSceneViewer;        //  
    GLCamera1: TGLCamera;           //  
    DCAI: TGLDummyCube;             //  
    ATimer1: TAsyncTimer;           //  
    Cad1: TGLCadencer;              // 
    player: TGLSprite;              // 
    Light: TGLLightSource;          // -
    DCCam: TGLDummyCube;            //   
    DCShoot: TGLDummyCube;          // ,   
    CollMan1: TCollisionManager;    //  
    WinFont1: TGLWindowsBitmapFont; //  
    DCPlayedMenu: TGLDummyCube;     //  
    HUDLevel: TGLHUDText;           //   
    HUDPerls: TGLHUDText;           //  - 
    HUDLifes: TGLHUDText;           //  - 
    GameMenu1: TGLGameMenu;         //  
    procedure FormCreate(Sender: TObject);                             // 
    procedure ATimer1Timer(Sender: TObject);                           // 
    procedure Cad1Progress(Sender: TObject; const deltaTime,           // 
      newTime: Double);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);    //  
    procedure CollMan1Collision(Sender: TObject; object1,              // 
      object2: TGLBaseSceneObject);
    procedure Viewer1MouseMove(Sender: TObject; Shift: TShiftState; X, //  
      Y: Integer);
    procedure Viewer1MouseDown(Sender: TObject; Button: TMouseButton;  //   
      Shift: TShiftState; X, Y: Integer);
    procedure FormKeyPress(Sender: TObject; var Key: Char);            //   
  private
    { Private declarations }
  public
    { Public declarations }
    procedure MapLoad(val: string);      //  
    procedure GameOver;                  //  
    procedure MustDie;                   //   
    procedure Shoot;                     // 
  end;

var
  frmMain: TfrmMain;    // o.O
  aDir   : string;      //   
  movLeft: boolean=true;//     
  snd_on : boolean=true;//  ,  

  level:  integer;      //  
  perls:  integer;      // 
  lifes:  integer;      // - 

  isMenu: boolean=false;//   

var
  Module  : PModule;
  fm      : TsvFile;
  fs3m    : Ps3m;
  fmod    : Pmod;
  fxm     : Pxm;
  driver  : PsvSoundDriver;
  dw      : PsvSondDriver_WaveOut;

implementation

{$R *.dfm}

Procedure OpenFile(filename:String);
begin
  fm := TsvFile.Create;
  if fm.svOpenFile(filename) then
  begin
    // Try to find the format of the file
    new(fs3m,init(driver^,fm));
    if (fs3m <> nil) then
      module := fs3m
    else
    begin
      fm.position := 0;
      new(fmod,init(driver^,fm));
      if (fmod <> nil) then
        module := fmod
      else
      begin
        fm.position := 0;
        new(fxm,init(driver^,fm));
        if (fxm <> nil) then
          module := fxm
        else
        begin
        end;
      end;
    end;
  if (module <> nil) then
  begin
    module^.play;
    module^.setramping(True);
    module^.setinterpolation(True);
  end;
  fm.svCloseFile;
  end else
  begin
    ShowMessage('Error : file not found or problem with access to file');
  end;
end;

//
var
  k_down:    integer;   //  ,, ** 
  k_ai_count:integer;   // -   

procedure TfrmMain.ATimer1Timer(Sender: TObject);
var
  i: integer; // 
begin
  //  
  HUDLevel.Text := 'Level: '+inttostr(level);
  HUDPerls.Text := 'Perls: '+inttostr(perls);
  HUDLifes.Text := 'Lifes: '+inttostr(lifes);
  //  1  5   
  if (DCAI.Children[0].Position.X < 1.0)or(DCAI.Children[0].Position.X > 5.2) then
    movLeft := not movLeft;
  if movLeft then
  begin
    for i := 0 to DCAI.Count - 1 do
      DCAI.Children[i].Position.X := DCAI.Children[i].Position.X - 0.4;
  end else
  begin
    for i := 0 to DCAI.Count - 1 do
      DCAI.Children[i].Position.X := DCAI.Children[i].Position.X + 0.4;
  end;
  //  11    
  if k_down = 11 then
  begin
    for i := 0 to DCAI.Count - 1 do
    begin
      DCAI.Children[i].Position.Z := DCAI.Children[i].Position.Z + 0.4;
      if (DCAI.Children[i].Position.Z>13)and(DCAI.Children[i].Visible) then MustDie;
    end;
    k_down := 0;
  end;
  k_down := k_down + 1;
end;

procedure TfrmMain.Shoot;
var
  shootnax: TGLSprite; // 
begin
  perls := perls - 1; //   -1 
  shootnax := TGLSprite.CreateAsChild(DCShoot);
  shootnax.Position.SetPoint(player.Position.X,0,player.Position.Z-0.5);
  shootnax.Width := 0.08;
  shootnax.Height:= 0.08;
  shootnax.Material.Texture.Disabled := False;
  shootnax.Material.Texture.Image.LoadFromFile(aDir + 'shoot.bmp');
  shootnax.Material.Texture.MagFilter := maNearest;
  shootnax.Tag := -1;
  with GetOrCreateCollision(shootnax) do
  begin
    BoundingMode := cbmFaces;
    Manager := CollMan1;
  end;
  if snd_on then
    Beep(3500,10);
end;

procedure TfrmMain.Viewer1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  GameMenu1.MouseMenuSelect(X, Y);
  case GameMenu1.Selected of
  0: ShowMessage('YEEAH! This is the rial ' + GameMenu1.SelectedText);
  1: ShowMessage('Press ESC to continue the game...');
  2: application.Terminate;
  end;
end;

procedure TfrmMain.Viewer1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  GameMenu1.MouseMenuSelect(X, Y); //   ,   
end;

procedure TfrmMain.Cad1Progress(Sender: TObject; const deltaTime,
  newTime: Double);
var
  i: integer;          // 
begin
  // .. =  
  if ((iskeydown(vk_left))or (iskeydown(ord('A'))))and(player.Position.X>1)   then
    player.Position.X := player.Position.X - 4*deltatime;
  if ((iskeydown(vk_right))or(iskeydown(ord('D'))))and(player.Position.X<12.8)then
    player.Position.X := player.Position.X + 4*deltatime;
  if (iskeydown(vk_space)) then
  begin
    if DCShoot.Count = 0 then
      Shoot
    else
      if DCShoot.Children[DCShoot.Count-1].Position.Z < 12 then
        Shoot;
  end;
  //    ()
  if DCShoot.Count > 0 then
    for i := DCShoot.Count - 1 downto 0 do
      if DCShoot.Children[i].Position.Z < -5 then
        DCShoot.Children[i].Free
      else
       DCShoot.Children[i].Position.Z := DCShoot.Children[i].Position.Z - 2*deltatime;
  //  
  CollMan1.CheckCollisions;
  // GameOver?
  k_ai_count := 0;
  for i := 0 to DCAI.Count - 1 do
    if (DCAI.Children[i].Tag<>0)and(DCAI.Children[i].Visible) then
      inc(k_ai_count);
  if k_ai_count = 0 then GameOver;
  // MyzON looping
  if (snd_on)and(module <> nil)and(not module^.isplaying) then module^.play;
  //  
  Viewer1.Invalidate;
end;

procedure TfrmMain.CollMan1Collision(Sender: TObject; object1,
  object2: TGLBaseSceneObject);
begin
  //     
  if (object1.Tag<>0)and(object2.Tag<>0)and(object1.Visible)and(object2.Visible) then
  begin
    Object1.Visible := false;
    Object2.Visible := false;
    if (object1.Tag=1)or(object2.Tag=1) then perls := perls + 2; //   1  1 
    if (object1.Tag=2)or(object2.Tag=2) then perls := perls + 3; //   2 
    if (object1.Tag=3)or(object2.Tag=3) then perls := perls + 4; // 3  - 3
    if (object1.Tag=4)or(object2.Tag=4) then perls := perls + 5; // 4  - 4
    if snd_on then Beep(500,50);
  end;
  //      (_|_)
  if ((object1=player)and(object2 <> nil))or((object2=player)and(object1<>nil)) then
    if ((object1.Visible)and(object2.Visible)) then
    begin
      if snd_on then Beep(100,50);
      lifes := lifes - 1;
      if lifes = 0 then MustDie;
      //   
      if object1 = player then
        object2.Free
      else
        object1.Free;
    end;
end;

procedure TfrmMain.MapLoad(val: string);
var
  i,j: integer;  //,   , ...
  f:   TextFile; //  ,   - 
  buf: integer;  //
  ai:  TGLSprite;//,   100 
begin
  //  
  DCAI.DeleteChildren;

  //     ( )
  AssignFile(f, val);
  reset(f);
  for i := 1 to 10 do
  begin
    for j := 1 to 10 do
    begin
      read(f, buf);
      ai := TGLSprite.CreateAsChild(DCAI);                                      //   1 ,
      ai.Position.SetPoint(1+(j-1)*0.64*1.3,0,1+(i-1)*0.64*1.3);                //    ,
      ai.Material.Texture.Disabled := false;                                    //    ,
      ai.Material.Texture.Image.LoadFromFile(aDir + 'enemy' + IntToStr(buf) + '.bmp'); //  ,
      ai.Tag := buf;                                                            //  ,
      ai.Width := 0.64;                                                         //  ...
      ai.Height:= 0.64;                                                         // ...,
      ai.Material.Texture.MagFilter := maNearest;                               //    ,
      ai.Name := 'enem'+IntToStr(DCAI.Count);                                   //   ...
      if buf = 0 then ai.Visible := false;                                      //   ,  ,
      with GetOrCreateCollision(ai) do                                          //  .
      begin
        BoundingMode := cbmFaces;
        Manager := CollMan1;
      end;
    end;
    readln(f);
  end;
  CloseFile(f);
end;

procedure TfrmMain.GameOver;
begin
  ATimer1.Enabled:= False;//  ,  i
  Cad1.Enabled   := False;   // -  

  level := level + 1;                           // next level
  //  :    . ,   
  //  ,    ,   
  //  .
  if fileexists(aDir + 'map'+inttostr(level)+'.txt') then
    MapLoad(aDir + 'map'+inttostr(level)+'.txt')
  else
    MustDie;
  ATimer1.Interval := 1000 div sqr(level);            // speed up
  if snd_on then                                      // MyzON
  begin
    if (module <> nil) then module^.stop;
    OpenFile(aDir+'music'+inttostr(random(3)+1)+'.s3m');
  end;

  ATimer1.Enabled := True;                      //  
  Cad1.Enabled    := True;                      //  , !
end;

procedure TfrmMain.MustDie;
var
  f: textfile;
  buf:integer;
begin
  if snd_on then beep(75,100);
  buf := 0;
  if fileexists(aDir + 'best.txt') then
  begin
    AssignFile(f, aDir + 'best.txt');
    Reset(f);
    readln(f,buf);
    CloseFile(f);
  end;
  ShowMessage('Your:     ' + inttostr(perls) + #13 + 'LastBest: ' + inttostr(buf));
  if perls > buf then
  begin
    AssignFile(f, aDir + 'best.txt');
    Rewrite(f);
    writeln(f,perls);
    CloseFile(f);
  end;
  application.Terminate;
end;

procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  //   !
  ATimer1.Free;
  Cad1.Free;
  Viewer1.Free;
  GLS1.Free;
  application.Terminate;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  randomize;

  aDir := extractfilepath(application.ExeName); //   ...

  new(dw,init(0));
  if (dw = nil) then snd_on := false
  else driver := dw;

  if (not driver^.PlayBack_Start(0,snd_auto)) then snd_on := false;

  with GetOrCreateCollision(player) do          //   ()
  begin
    BoundingMode := cbmFaces;
    Manager := CollMan1;
  end;
  perls := 0;
  level := 0;
  lifes := 3;

  GameOver;
end;

procedure TfrmMain.FormKeyPress(Sender: TObject; var Key: Char);
begin
  // C... =  
  if IsKeyDown(VK_ESCAPE) then isMenu := not isMenu;
  if isMenu then
  begin
    Cad1.Enabled     := False; //    
    ATimer1.Enabled  := False; //    
    DCAI.Visible     := False; //   
    DCShoot.Visible  := False; //   
    GameMenu1.Visible:= True;  //  
  end else
  begin
    Cad1.Enabled     := True;  //  
    ATimer1.Enabled  := True;
    DCAI.Visible     := True;
    DCShoot.Visible  := True;
    GameMenu1.Visible:= False;
  end;
end;

end.
