unit _draw;

interface

uses _var, _scd, exgine, openGL;

procedure draw(tx:TTexture; x,y,w,h,angle:single{; scale:boolean=true});
procedure drawtxt(tx:TTexture; x,y,z,w,h,angle:single);

implementation

//----------------------------------------------------------------------------------------------------------------------------------------------------

procedure draw(tx:TTexture; x,y,w,h,angle:single{; scale:boolean=true});
var wd,hd:integer;
begin
 glPushMatrix;
 tex.Enable(tx);
 glDisable(GL_COLOR_MATERIAL);
 wd:=1;
 hd:=1;
// if scale then
//     glTranslatef(x+w/2,y+h/2,0);
//   else
     glTranslatef(x,y,0);

 glRotatef(angle,0,0,1);
 glBegin(GL_QUADS);
  glTexCoord2d(0,0); glVertex2f(-w/2,-h/2);
  glTexCoord2d(wd,0); glVertex2f(w/2,-h/2);
  glTexCoord2d(wd,hd); glVertex2f(w/2,h/2);
  glTexCoord2d(0,hd); glVertex2f(-w/2,h/2);
 glEnd;
 tex.Disable;
 glPopMatrix;
end;

//----------------------------------------------------------------------------------------------------------------------------------------------------

procedure drawtxt(tx:TTexture; x,y,z,w,h,angle:single);
var wd,hd:integer;
begin
 glPushMatrix;
 tex.Enable(tx);
 glDisable(GL_COLOR_MATERIAL);
 wd:=1;
 hd:=1;
 glRotatef(-70,1,0,0);
 glTranslatef(0,z,0);
 glBegin(GL_QUADS);
  glTexCoord2d(0,0); glVertex3f(-w/2,h/2,0);
  glTexCoord2d(wd,0); glVertex3f(w/2,h/2,0);
  glTexCoord2d(wd,hd);glVertex3f(w/2,-h/2,0);
  glTexCoord2d(0,hd); glVertex3f(-w/2,-h/2,0);

 glEnd;
 tex.Disable;
 glPopMatrix;
end;

//----------------------------------------------------------------------------------------------------------------------------------------------------

end.



