unit uRes;

interface
uses
  zglHeader;

const
  TEX_DEFAULT_3D = TEX_MIPMAP or TEX_CLAMP or TEX_FILTER_ANISOTROPY;
  cv_pi180 = 3.14 / 180;

  dir_prefix         = './';
  dir_data           = dir_prefix + 'data/';
  dir_gui            = dir_prefix + 'data/gui/';
  dir_maps           = dir_prefix + 'data/maps/';
  dir_models         = dir_prefix + 'data/models/';
  dir_models_player  = dir_prefix + 'data/models/player/';
  dir_models_enemies = dir_prefix + 'data/models/enemies/';
  dir_models_bonuses = dir_prefix + 'data/models/bonuses/';
  dir_models_bullets = dir_prefix + 'data/models/bullets/';
  dir_texs           = dir_prefix + 'data/textures/';
  dir_sfx            = dir_prefix + 'data/sfx/';

procedure res_Load;

var
  fnt : zglPFont;

  tex_car      : array[ 0..2 ] of zglPTexture;
  tex_alien    : array[ 0..2 ] of zglPTexture;
  tex_particle : array[ 0..7 ] of zglPTexture;
  tex_bullet   : array[ 0..2 ] of zglPTexture;
  tex_ebullet  : array[ 0..2 ] of zglPTexture;
  tex_bonus    : array[ 0..1 ] of zglPTexture;

  sm_player : array[ 0..2 ] of zglPSMesh;
  sm_alien  : array[ 0..2 ] of zglPSMesh;

  sm_bonus  : array[ 0..1 ] of zglPSMesh;
  sm_bullet : array[ 0..1 ] of zglPSMesh;

  tex_Map01 : zglPTexture;
  tex_GMap01 : zglPTexture;
  tex_Detail : zglPTexture;
  hm_Map01 : zglPHeightMap;

  s_Shoot1    : zglPSound;
  s_Shoot2    : zglPSound;
  s_Explosion : zglPSound;

  debug : Boolean;

implementation
uses
  uOptions;

procedure res_Load;
  var
    sf : Integer;
begin
  fnt := font_LoadFromFile( dir_gui + 'font.png', dir_gui + 'font.zfi' );

  smesh_LoadFromFile( sm_player[ 0 ], dir_models_player + 'spacecar.zmf' );
  smesh_LoadFromFile( sm_player[ 1 ], dir_models_player + 'spacecar-wheels.zmf' );
  smesh_LoadFromFile( sm_player[ 2 ], dir_models_player + 'spacecar-window.zmf' );

  smesh_LoadFromFile( sm_alien[ 0 ], dir_models_enemies + 'alien01.zmf' );
  sm_alien[ 1 ] := sm_alien[ 0 ];
  smesh_LoadFromFile( sm_alien[ 2 ], dir_models_enemies + 'alien03.zmf' );

  smesh_LoadFromFile( sm_bonus[ 0 ], dir_models_bonuses + 'weaponup.zmf' );

  // car
  tex_car[ 0 ] := tex_LoadFromFile( dir_texs + 'spacecar.png', $FF000000, TEX_DEFAULT_3D or TEX_RGB );
  tex_car[ 1 ] := tex_LoadFromFile( dir_texs + 'spacecar-wheels.png', $FF000000, TEX_DEFAULT_3D or TEX_RGB );
  tex_car[ 2 ] := tex_LoadFromFile( dir_texs + 'spacecar-window.png', $FF000000, TEX_DEFAULT_3D or TEX_RGB );

  // alien
  tex_alien[ 0 ] := tex_LoadFromFile( dir_texs + 'alien01.jpg', $FF000000, TEX_DEFAULT_3D or TEX_RGB );
  tex_alien[ 1 ] := tex_LoadFromFile( dir_texs + 'alien02.jpg', $FF000000, TEX_DEFAULT_3D or TEX_RGB );
  tex_alien[ 2 ] := tex_LoadFromFile( dir_texs + 'alien03.jpg', $FF000000, TEX_DEFAULT_3D or TEX_RGB );

  // particles
  tex_particle[ 0 ] := tex_LoadFromFile( dir_texs + 'particle01.png', $FF000000, TEX_DEFAULT_3D or TEX_RGB );
  tex_particle[ 1 ] := tex_particle[ 0 ];
  tex_particle[ 2 ] := tex_LoadFromFile( dir_texs + 'boom01.png', $FF000000, TEX_DEFAULT_3D or TEX_RGB );
  tex_particle[ 3 ] := tex_LoadFromFile( dir_texs + 'particle02.png', $FF000000, TEX_DEFAULT_3D or TEX_RGB );
  tex_particle[ 4 ] := tex_particle[ 3 ];
  tex_particle[ 5 ] := tex_LoadFromFile( dir_texs + 'particle03.png', $FF000000, TEX_DEFAULT_3D or TEX_RGB );
  tex_particle[ 6 ] := tex_LoadFromFile( dir_texs + 'smoke.png', $FF000000, TEX_DEFAULT_3D );
  tex_particle[ 7 ] := tex_particle[ 3 ];

  // bullets
  tex_bullet[ 0 ] := tex_LoadFromFile( dir_texs + 'bullet01.png', $FF000000, TEX_DEFAULT_3D or TEX_RGB );
  tex_bullet[ 1 ] := tex_bullet[ 0 ];
  tex_ebullet[ 0 ] := tex_particle[ 3 ];
  tex_ebullet[ 1 ] := tex_ebullet[ 0 ];

  tex_bonus[ 0 ] := tex_LoadFromFile( dir_texs + 'powerup.png', $FF000000, TEX_DEFAULT_3D or TEX_RGB );

  // heightmap
  if oHeightMap = 1 Then
    begin
      sf := 1;
      tex_Map01 :=  tex_LoadFromFile( dir_maps + 'map01.png', $FF000000, TEX_DEFAULT_2D or TEX_RGB )
    end else
      begin
        sf := 2;
        tex_Map01 :=  tex_LoadFromFile( dir_maps + 'map01low.png', $FF000000, TEX_DEFAULT_2D or TEX_RGB );
      end;

  tex_GMap01 :=  tex_LoadFromFile( dir_maps + 'gmap01.jpg', $FF000000, TEX_DEFAULT_3D or TEX_RGB );
  tex_Detail :=  tex_LoadFromFile( dir_maps + 'detail.jpg', $FF000000, TEX_DEFAULT_3D xor TEX_CLAMP or TEX_RGB );
  heightmap_Build( hm_Map01, tex_Map01, 1.5 * sf, 0.115, 1 * sf, 16, 32, USE_TEXTURE or USE_MULTITEX1 or BUILD_VBO or BUILD_PLANES );

  s_Shoot1    := snd_LoadFromFile( dir_sfx + 'shoot01.wav', 32 );
  s_Shoot2    := snd_LoadFromFile( dir_sfx + 'shoot02.wav', 32 );
  s_Explosion := snd_LoadFromFile( dir_sfx + 'explosion.wav', 32 );
end;

end.
